package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait PreserveDevices {
  def unwrap: software.amazon.awssdk.services.datasync.model.PreserveDevices
}
object PreserveDevices {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.PreserveDevices
  ): zio.aws.datasync.model.PreserveDevices = value match {
    case software.amazon.awssdk.services.datasync.model.PreserveDevices.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.PreserveDevices.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.PreserveDevices.PRESERVE =>
      val r = PRESERVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.PreserveDevices {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PreserveDevices =
      software.amazon.awssdk.services.datasync.model.PreserveDevices.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.PreserveDevices {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PreserveDevices =
      software.amazon.awssdk.services.datasync.model.PreserveDevices.NONE
  }
  case object PRESERVE extends zio.aws.datasync.model.PreserveDevices {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PreserveDevices =
      software.amazon.awssdk.services.datasync.model.PreserveDevices.PRESERVE
  }
}
