package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationStatus {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.RecommendationStatus
}
object RecommendationStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.RecommendationStatus
  ): zio.aws.datasync.model.RecommendationStatus = value match {
    case software.amazon.awssdk.services.datasync.model.RecommendationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.RecommendationStatus.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.RecommendationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.datasync.model.RecommendationStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.datasync.model.RecommendationStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.RecommendationStatus =
      software.amazon.awssdk.services.datasync.model.RecommendationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.RecommendationStatus =
      software.amazon.awssdk.services.datasync.model.RecommendationStatus.NONE
  }
  case object IN_PROGRESS extends zio.aws.datasync.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.RecommendationStatus =
      software.amazon.awssdk.services.datasync.model.RecommendationStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.datasync.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.RecommendationStatus =
      software.amazon.awssdk.services.datasync.model.RecommendationStatus.COMPLETED
  }
  case object FAILED extends zio.aws.datasync.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.RecommendationStatus =
      software.amazon.awssdk.services.datasync.model.RecommendationStatus.FAILED
  }
}
