package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceDetails(
    netAppONTAPSVMs: Optional[Iterable[zio.aws.datasync.model.NetAppONTAPSVM]] =
      Optional.Absent,
    netAppONTAPVolumes: Optional[
      Iterable[zio.aws.datasync.model.NetAppONTAPVolume]
    ] = Optional.Absent,
    netAppONTAPClusters: Optional[
      Iterable[zio.aws.datasync.model.NetAppONTAPCluster]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ResourceDetails
      .builder()
      .optionallyWith(
        netAppONTAPSVMs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.netAppONTAPSVMs)
      .optionallyWith(
        netAppONTAPVolumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.netAppONTAPVolumes)
      .optionallyWith(
        netAppONTAPClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.netAppONTAPClusters)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ResourceDetails.ReadOnly =
    zio.aws.datasync.model.ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ResourceDetails =
      zio.aws.datasync.model.ResourceDetails(
        netAppONTAPSVMs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        netAppONTAPVolumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        netAppONTAPClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def netAppONTAPSVMs
        : Optional[List[zio.aws.datasync.model.NetAppONTAPSVM.ReadOnly]]
    def netAppONTAPVolumes
        : Optional[List[zio.aws.datasync.model.NetAppONTAPVolume.ReadOnly]]
    def netAppONTAPClusters
        : Optional[List[zio.aws.datasync.model.NetAppONTAPCluster.ReadOnly]]
    def getNetAppONTAPSVMs: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.NetAppONTAPSVM.ReadOnly
    ]] = AwsError.unwrapOptionField("netAppONTAPSVMs", netAppONTAPSVMs)
    def getNetAppONTAPVolumes: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.NetAppONTAPVolume.ReadOnly
    ]] = AwsError.unwrapOptionField("netAppONTAPVolumes", netAppONTAPVolumes)
    def getNetAppONTAPClusters: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.NetAppONTAPCluster.ReadOnly
    ]] = AwsError.unwrapOptionField("netAppONTAPClusters", netAppONTAPClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ResourceDetails
  ) extends zio.aws.datasync.model.ResourceDetails.ReadOnly {
    override val netAppONTAPSVMs
        : Optional[List[zio.aws.datasync.model.NetAppONTAPSVM.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.netAppONTAPSVMs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.NetAppONTAPSVM.wrap(item)
          }.toList
        )
    override val netAppONTAPVolumes
        : Optional[List[zio.aws.datasync.model.NetAppONTAPVolume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.netAppONTAPVolumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.NetAppONTAPVolume.wrap(item)
          }.toList
        )
    override val netAppONTAPClusters
        : Optional[List[zio.aws.datasync.model.NetAppONTAPCluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.netAppONTAPClusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.NetAppONTAPCluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ResourceDetails
  ): zio.aws.datasync.model.ResourceDetails.ReadOnly = new Wrapper(impl)
}
