package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  S3ObjectVersionId,
  S3BucketArn,
  IamRoleArn,
  S3Subdirectory
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ManifestConfig(
    manifestObjectPath: S3Subdirectory,
    bucketAccessRoleArn: IamRoleArn,
    s3BucketArn: S3BucketArn,
    manifestObjectVersionId: Optional[S3ObjectVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.S3ManifestConfig = {
    import S3ManifestConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.S3ManifestConfig
      .builder()
      .manifestObjectPath(
        S3Subdirectory.unwrap(manifestObjectPath): java.lang.String
      )
      .bucketAccessRoleArn(
        IamRoleArn.unwrap(bucketAccessRoleArn): java.lang.String
      )
      .s3BucketArn(S3BucketArn.unwrap(s3BucketArn): java.lang.String)
      .optionallyWith(
        manifestObjectVersionId.map(value =>
          S3ObjectVersionId.unwrap(value): java.lang.String
        )
      )(_.manifestObjectVersionId)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.S3ManifestConfig.ReadOnly =
    zio.aws.datasync.model.S3ManifestConfig.wrap(buildAwsValue())
}
object S3ManifestConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.S3ManifestConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.S3ManifestConfig =
      zio.aws.datasync.model.S3ManifestConfig(
        manifestObjectPath,
        bucketAccessRoleArn,
        s3BucketArn,
        manifestObjectVersionId.map(value => value)
      )
    def manifestObjectPath: S3Subdirectory
    def bucketAccessRoleArn: IamRoleArn
    def s3BucketArn: S3BucketArn
    def manifestObjectVersionId: Optional[S3ObjectVersionId]
    def getManifestObjectPath: ZIO[Any, Nothing, S3Subdirectory] =
      ZIO.succeed(manifestObjectPath)
    def getBucketAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(bucketAccessRoleArn)
    def getS3BucketArn: ZIO[Any, Nothing, S3BucketArn] =
      ZIO.succeed(s3BucketArn)
    def getManifestObjectVersionId: ZIO[Any, AwsError, S3ObjectVersionId] =
      AwsError.unwrapOptionField(
        "manifestObjectVersionId",
        manifestObjectVersionId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.S3ManifestConfig
  ) extends zio.aws.datasync.model.S3ManifestConfig.ReadOnly {
    override val manifestObjectPath: S3Subdirectory =
      zio.aws.datasync.model.primitives
        .S3Subdirectory(impl.manifestObjectPath())
    override val bucketAccessRoleArn: IamRoleArn =
      zio.aws.datasync.model.primitives.IamRoleArn(impl.bucketAccessRoleArn())
    override val s3BucketArn: S3BucketArn =
      zio.aws.datasync.model.primitives.S3BucketArn(impl.s3BucketArn())
    override val manifestObjectVersionId: Optional[S3ObjectVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestObjectVersionId())
        .map(value =>
          zio.aws.datasync.model.primitives.S3ObjectVersionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.S3ManifestConfig
  ): zio.aws.datasync.model.S3ManifestConfig.ReadOnly = new Wrapper(impl)
}
