package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait ScheduleStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.ScheduleStatus
}
object ScheduleStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ScheduleStatus
  ): zio.aws.datasync.model.ScheduleStatus = value match {
    case software.amazon.awssdk.services.datasync.model.ScheduleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ScheduleStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.datasync.model.ScheduleStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ScheduleStatus =
      software.amazon.awssdk.services.datasync.model.ScheduleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.datasync.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ScheduleStatus =
      software.amazon.awssdk.services.datasync.model.ScheduleStatus.ENABLED
  }
  case object DISABLED extends zio.aws.datasync.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ScheduleStatus =
      software.amazon.awssdk.services.datasync.model.ScheduleStatus.DISABLED
  }
}
