package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait SmbAuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.SmbAuthenticationType
}
object SmbAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.SmbAuthenticationType
  ): zio.aws.datasync.model.SmbAuthenticationType = value match {
    case software.amazon.awssdk.services.datasync.model.SmbAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.SmbAuthenticationType.NTLM =>
      val r = NTLM
      r
    case software.amazon.awssdk.services.datasync.model.SmbAuthenticationType.KERBEROS =>
      val r = KERBEROS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.SmbAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbAuthenticationType =
      software.amazon.awssdk.services.datasync.model.SmbAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object NTLM extends zio.aws.datasync.model.SmbAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbAuthenticationType =
      software.amazon.awssdk.services.datasync.model.SmbAuthenticationType.NTLM
  }
  case object KERBEROS extends zio.aws.datasync.model.SmbAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbAuthenticationType =
      software.amazon.awssdk.services.datasync.model.SmbAuthenticationType.KERBEROS
  }
}
