package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SourceManifestConfig(
    s3: zio.aws.datasync.model.S3ManifestConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.SourceManifestConfig = {
    import SourceManifestConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.SourceManifestConfig
      .builder()
      .s3(s3.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.SourceManifestConfig.ReadOnly =
    zio.aws.datasync.model.SourceManifestConfig.wrap(buildAwsValue())
}
object SourceManifestConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.SourceManifestConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.SourceManifestConfig =
      zio.aws.datasync.model.SourceManifestConfig(s3.asEditable)
    def s3: zio.aws.datasync.model.S3ManifestConfig.ReadOnly
    def getS3
        : ZIO[Any, Nothing, zio.aws.datasync.model.S3ManifestConfig.ReadOnly] =
      ZIO.succeed(s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.SourceManifestConfig
  ) extends zio.aws.datasync.model.SourceManifestConfig.ReadOnly {
    override val s3: zio.aws.datasync.model.S3ManifestConfig.ReadOnly =
      zio.aws.datasync.model.S3ManifestConfig.wrap(impl.s3())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.SourceManifestConfig
  ): zio.aws.datasync.model.SourceManifestConfig.ReadOnly = new Wrapper(impl)
}
