package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskExecutionFilesFailedDetail(
    prepare: Optional[Long] = Optional.Absent,
    transfer: Optional[Long] = Optional.Absent,
    verify: Optional[Long] = Optional.Absent,
    delete: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskExecutionFilesFailedDetail = {
    import TaskExecutionFilesFailedDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskExecutionFilesFailedDetail
      .builder()
      .optionallyWith(prepare.map(value => value: java.lang.Long))(_.prepare)
      .optionallyWith(transfer.map(value => value: java.lang.Long))(_.transfer)
      .optionallyWith(verify.map(value => value: java.lang.Long))(_.verify)
      .optionallyWith(delete.map(value => value: java.lang.Long))(_.delete)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.TaskExecutionFilesFailedDetail.ReadOnly =
    zio.aws.datasync.model.TaskExecutionFilesFailedDetail.wrap(buildAwsValue())
}
object TaskExecutionFilesFailedDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskExecutionFilesFailedDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskExecutionFilesFailedDetail =
      zio.aws.datasync.model.TaskExecutionFilesFailedDetail(
        prepare.map(value => value),
        transfer.map(value => value),
        verify.map(value => value),
        delete.map(value => value)
      )
    def prepare: Optional[Long]
    def transfer: Optional[Long]
    def verify: Optional[Long]
    def delete: Optional[Long]
    def getPrepare: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("prepare", prepare)
    def getTransfer: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("transfer", transfer)
    def getVerify: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("verify", verify)
    def getDelete: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionFilesFailedDetail
  ) extends zio.aws.datasync.model.TaskExecutionFilesFailedDetail.ReadOnly {
    override val prepare: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.prepare())
      .map(value => value: Long)
    override val transfer: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.transfer())
      .map(value => value: Long)
    override val verify: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.verify())
      .map(value => value: Long)
    override val delete: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.delete())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionFilesFailedDetail
  ): zio.aws.datasync.model.TaskExecutionFilesFailedDetail.ReadOnly =
    new Wrapper(impl)
}
