package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskExecutionFilesListedDetail(
    atSource: Optional[Long] = Optional.Absent,
    atDestinationForDelete: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskExecutionFilesListedDetail = {
    import TaskExecutionFilesListedDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskExecutionFilesListedDetail
      .builder()
      .optionallyWith(atSource.map(value => value: java.lang.Long))(_.atSource)
      .optionallyWith(
        atDestinationForDelete.map(value => value: java.lang.Long)
      )(_.atDestinationForDelete)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.TaskExecutionFilesListedDetail.ReadOnly =
    zio.aws.datasync.model.TaskExecutionFilesListedDetail.wrap(buildAwsValue())
}
object TaskExecutionFilesListedDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskExecutionFilesListedDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskExecutionFilesListedDetail =
      zio.aws.datasync.model.TaskExecutionFilesListedDetail(
        atSource.map(value => value),
        atDestinationForDelete.map(value => value)
      )
    def atSource: Optional[Long]
    def atDestinationForDelete: Optional[Long]
    def getAtSource: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("atSource", atSource)
    def getAtDestinationForDelete: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("atDestinationForDelete", atDestinationForDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionFilesListedDetail
  ) extends zio.aws.datasync.model.TaskExecutionFilesListedDetail.ReadOnly {
    override val atSource: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.atSource())
      .map(value => value: Long)
    override val atDestinationForDelete: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.atDestinationForDelete())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionFilesListedDetail
  ): zio.aws.datasync.model.TaskExecutionFilesListedDetail.ReadOnly =
    new Wrapper(impl)
}
