package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskExecutionListEntry(
    taskExecutionArn: Optional[TaskExecutionArn] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.TaskExecutionStatus] =
      Optional.Absent,
    taskMode: Optional[zio.aws.datasync.model.TaskMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry = {
    import TaskExecutionListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
      .builder()
      .optionallyWith(
        taskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.taskExecutionArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(taskMode.map(value => value.unwrap))(_.taskMode)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly =
    zio.aws.datasync.model.TaskExecutionListEntry.wrap(buildAwsValue())
}
object TaskExecutionListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskExecutionListEntry =
      zio.aws.datasync.model.TaskExecutionListEntry(
        taskExecutionArn.map(value => value),
        status.map(value => value),
        taskMode.map(value => value)
      )
    def taskExecutionArn: Optional[TaskExecutionArn]
    def status: Optional[zio.aws.datasync.model.TaskExecutionStatus]
    def taskMode: Optional[zio.aws.datasync.model.TaskMode]
    def getTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField("taskExecutionArn", taskExecutionArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTaskMode: ZIO[Any, AwsError, zio.aws.datasync.model.TaskMode] =
      AwsError.unwrapOptionField("taskMode", taskMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
  ) extends zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly {
    override val taskExecutionArn: Optional[TaskExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskExecutionArn())
        .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
    override val status: Optional[zio.aws.datasync.model.TaskExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.TaskExecutionStatus.wrap(value))
    override val taskMode: Optional[zio.aws.datasync.model.TaskMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskMode())
        .map(value => zio.aws.datasync.model.TaskMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry
  ): zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly = new Wrapper(impl)
}
