package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait TaskFilterName {
  def unwrap: software.amazon.awssdk.services.datasync.model.TaskFilterName
}
object TaskFilterName {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.TaskFilterName
  ): zio.aws.datasync.model.TaskFilterName = value match {
    case software.amazon.awssdk.services.datasync.model.TaskFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.TaskFilterName.LOCATION_ID =>
      val r = LocationId
      r
    case software.amazon.awssdk.services.datasync.model.TaskFilterName.CREATION_TIME =>
      val r = CreationTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.TaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskFilterName =
      software.amazon.awssdk.services.datasync.model.TaskFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object LocationId extends zio.aws.datasync.model.TaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskFilterName =
      software.amazon.awssdk.services.datasync.model.TaskFilterName.LOCATION_ID
  }
  case object CreationTime extends zio.aws.datasync.model.TaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskFilterName =
      software.amazon.awssdk.services.datasync.model.TaskFilterName.CREATION_TIME
  }
}
