package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, TaskArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskListEntry(
    taskArn: Optional[TaskArn] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.TaskStatus] = Optional.Absent,
    name: Optional[TagValue] = Optional.Absent,
    taskMode: Optional[zio.aws.datasync.model.TaskMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskListEntry = {
    import TaskListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskListEntry
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(taskMode.map(value => value.unwrap))(_.taskMode)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskListEntry.ReadOnly =
    zio.aws.datasync.model.TaskListEntry.wrap(buildAwsValue())
}
object TaskListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskListEntry =
      zio.aws.datasync.model.TaskListEntry(
        taskArn.map(value => value),
        status.map(value => value),
        name.map(value => value),
        taskMode.map(value => value)
      )
    def taskArn: Optional[TaskArn]
    def status: Optional[zio.aws.datasync.model.TaskStatus]
    def name: Optional[TagValue]
    def taskMode: Optional[zio.aws.datasync.model.TaskMode]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getTaskMode: ZIO[Any, AwsError, zio.aws.datasync.model.TaskMode] =
      AwsError.unwrapOptionField("taskMode", taskMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskListEntry
  ) extends zio.aws.datasync.model.TaskListEntry.ReadOnly {
    override val taskArn: Optional[TaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
    override val status: Optional[zio.aws.datasync.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.TaskStatus.wrap(value))
    override val name: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val taskMode: Optional[zio.aws.datasync.model.TaskMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskMode())
        .map(value => zio.aws.datasync.model.TaskMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskListEntry
  ): zio.aws.datasync.model.TaskListEntry.ReadOnly = new Wrapper(impl)
}
