package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait TaskMode {
  def unwrap: software.amazon.awssdk.services.datasync.model.TaskMode
}
object TaskMode {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.TaskMode
  ): zio.aws.datasync.model.TaskMode = value match {
    case software.amazon.awssdk.services.datasync.model.TaskMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.TaskMode.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.datasync.model.TaskMode.ENHANCED =>
      val r = ENHANCED
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.TaskMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskMode =
      software.amazon.awssdk.services.datasync.model.TaskMode.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC extends zio.aws.datasync.model.TaskMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskMode =
      software.amazon.awssdk.services.datasync.model.TaskMode.BASIC
  }
  case object ENHANCED extends zio.aws.datasync.model.TaskMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskMode =
      software.amazon.awssdk.services.datasync.model.TaskMode.ENHANCED
  }
}
