package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.ScheduleExpressionCron
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskSchedule(
    scheduleExpression: ScheduleExpressionCron,
    status: Optional[zio.aws.datasync.model.ScheduleStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskSchedule = {
    import TaskSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskSchedule
      .builder()
      .scheduleExpression(
        ScheduleExpressionCron.unwrap(scheduleExpression): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskSchedule.ReadOnly =
    zio.aws.datasync.model.TaskSchedule.wrap(buildAwsValue())
}
object TaskSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskSchedule = zio.aws.datasync.model
      .TaskSchedule(scheduleExpression, status.map(value => value))
    def scheduleExpression: ScheduleExpressionCron
    def status: Optional[zio.aws.datasync.model.ScheduleStatus]
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpressionCron] =
      ZIO.succeed(scheduleExpression)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.ScheduleStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskSchedule
  ) extends zio.aws.datasync.model.TaskSchedule.ReadOnly {
    override val scheduleExpression: ScheduleExpressionCron =
      zio.aws.datasync.model.primitives
        .ScheduleExpressionCron(impl.scheduleExpression())
    override val status: Optional[zio.aws.datasync.model.ScheduleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.ScheduleStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskSchedule
  ): zio.aws.datasync.model.TaskSchedule.ReadOnly = new Wrapper(impl)
}
