package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{ScheduleDisabledReason, Time}
import scala.jdk.CollectionConverters._
final case class TaskScheduleDetails(
    statusUpdateTime: Optional[Time] = Optional.Absent,
    disabledReason: Optional[ScheduleDisabledReason] = Optional.Absent,
    disabledBy: Optional[zio.aws.datasync.model.ScheduleDisabledBy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskScheduleDetails = {
    import TaskScheduleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskScheduleDetails
      .builder()
      .optionallyWith(
        statusUpdateTime.map(value => Time.unwrap(value): Instant)
      )(_.statusUpdateTime)
      .optionallyWith(
        disabledReason.map(value =>
          ScheduleDisabledReason.unwrap(value): java.lang.String
        )
      )(_.disabledReason)
      .optionallyWith(disabledBy.map(value => value.unwrap))(_.disabledBy)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskScheduleDetails.ReadOnly =
    zio.aws.datasync.model.TaskScheduleDetails.wrap(buildAwsValue())
}
object TaskScheduleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskScheduleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskScheduleDetails =
      zio.aws.datasync.model.TaskScheduleDetails(
        statusUpdateTime.map(value => value),
        disabledReason.map(value => value),
        disabledBy.map(value => value)
      )
    def statusUpdateTime: Optional[Time]
    def disabledReason: Optional[ScheduleDisabledReason]
    def disabledBy: Optional[zio.aws.datasync.model.ScheduleDisabledBy]
    def getStatusUpdateTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("statusUpdateTime", statusUpdateTime)
    def getDisabledReason: ZIO[Any, AwsError, ScheduleDisabledReason] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
    def getDisabledBy
        : ZIO[Any, AwsError, zio.aws.datasync.model.ScheduleDisabledBy] =
      AwsError.unwrapOptionField("disabledBy", disabledBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskScheduleDetails
  ) extends zio.aws.datasync.model.TaskScheduleDetails.ReadOnly {
    override val statusUpdateTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.statusUpdateTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val disabledReason: Optional[ScheduleDisabledReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disabledReason())
        .map(value =>
          zio.aws.datasync.model.primitives.ScheduleDisabledReason(value)
        )
    override val disabledBy
        : Optional[zio.aws.datasync.model.ScheduleDisabledBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disabledBy())
        .map(value => zio.aws.datasync.model.ScheduleDisabledBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskScheduleDetails
  ): zio.aws.datasync.model.TaskScheduleDetails.ReadOnly = new Wrapper(impl)
}
