package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagKey, TaggableResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: TaggableResourceArn,
    keys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UntagResourceRequest
      .builder()
      .resourceArn(TaggableResourceArn.unwrap(resourceArn): java.lang.String)
      .keys(keys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UntagResourceRequest.ReadOnly =
    zio.aws.datasync.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UntagResourceRequest =
      zio.aws.datasync.model.UntagResourceRequest(resourceArn, keys)
    def resourceArn: TaggableResourceArn
    def keys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, TaggableResourceArn] =
      ZIO.succeed(resourceArn)
    def getKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(keys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UntagResourceRequest
  ) extends zio.aws.datasync.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: TaggableResourceArn =
      zio.aws.datasync.model.primitives.TaggableResourceArn(impl.resourceArn())
    override val keys: List[TagKey] = impl
      .keys()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UntagResourceRequest
  ): zio.aws.datasync.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
