package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  UpdatedEfsIamRoleArn,
  UpdatedEfsAccessPointArn,
  EfsSubdirectory,
  LocationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationEfsRequest(
    locationArn: LocationArn,
    subdirectory: Optional[EfsSubdirectory] = Optional.Absent,
    accessPointArn: Optional[UpdatedEfsAccessPointArn] = Optional.Absent,
    fileSystemAccessRoleArn: Optional[UpdatedEfsIamRoleArn] = Optional.Absent,
    inTransitEncryption: Optional[
      zio.aws.datasync.model.EfsInTransitEncryption
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest = {
    import UpdateLocationEfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          EfsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        accessPointArn.map(value =>
          UpdatedEfsAccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(
        fileSystemAccessRoleArn.map(value =>
          UpdatedEfsIamRoleArn.unwrap(value): java.lang.String
        )
      )(_.fileSystemAccessRoleArn)
      .optionallyWith(inTransitEncryption.map(value => value.unwrap))(
        _.inTransitEncryption
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateLocationEfsRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationEfsRequest.wrap(buildAwsValue())
}
object UpdateLocationEfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationEfsRequest =
      zio.aws.datasync.model.UpdateLocationEfsRequest(
        locationArn,
        subdirectory.map(value => value),
        accessPointArn.map(value => value),
        fileSystemAccessRoleArn.map(value => value),
        inTransitEncryption.map(value => value)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[EfsSubdirectory]
    def accessPointArn: Optional[UpdatedEfsAccessPointArn]
    def fileSystemAccessRoleArn: Optional[UpdatedEfsIamRoleArn]
    def inTransitEncryption
        : Optional[zio.aws.datasync.model.EfsInTransitEncryption]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, EfsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getAccessPointArn: ZIO[Any, AwsError, UpdatedEfsAccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getFileSystemAccessRoleArn: ZIO[Any, AwsError, UpdatedEfsIamRoleArn] =
      AwsError.unwrapOptionField(
        "fileSystemAccessRoleArn",
        fileSystemAccessRoleArn
      )
    def getInTransitEncryption
        : ZIO[Any, AwsError, zio.aws.datasync.model.EfsInTransitEncryption] =
      AwsError.unwrapOptionField("inTransitEncryption", inTransitEncryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest
  ) extends zio.aws.datasync.model.UpdateLocationEfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[EfsSubdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.EfsSubdirectory(value))
    override val accessPointArn: Optional[UpdatedEfsAccessPointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPointArn())
        .map(value =>
          zio.aws.datasync.model.primitives.UpdatedEfsAccessPointArn(value)
        )
    override val fileSystemAccessRoleArn: Optional[UpdatedEfsIamRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemAccessRoleArn())
        .map(value =>
          zio.aws.datasync.model.primitives.UpdatedEfsIamRoleArn(value)
        )
    override val inTransitEncryption
        : Optional[zio.aws.datasync.model.EfsInTransitEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inTransitEncryption())
        .map(value => zio.aws.datasync.model.EfsInTransitEncryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationEfsRequest
  ): zio.aws.datasync.model.UpdateLocationEfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
