package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{SmbSubdirectory, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationFsxLustreRequest(
    locationArn: LocationArn,
    subdirectory: Optional[SmbSubdirectory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest = {
    import UpdateLocationFsxLustreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          SmbSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationFsxLustreRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationFsxLustreRequest.wrap(buildAwsValue())
}
object UpdateLocationFsxLustreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationFsxLustreRequest =
      zio.aws.datasync.model.UpdateLocationFsxLustreRequest(
        locationArn,
        subdirectory.map(value => value)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[SmbSubdirectory]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, SmbSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest
  ) extends zio.aws.datasync.model.UpdateLocationFsxLustreRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[SmbSubdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.SmbSubdirectory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxLustreRequest
  ): zio.aws.datasync.model.UpdateLocationFsxLustreRequest.ReadOnly =
    new Wrapper(impl)
}
