package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{FsxOntapSubdirectory, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationFsxOntapRequest(
    locationArn: LocationArn,
    protocol: Optional[zio.aws.datasync.model.FsxUpdateProtocol] =
      Optional.Absent,
    subdirectory: Optional[FsxOntapSubdirectory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest = {
    import UpdateLocationFsxOntapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(protocol.map(value => value.buildAwsValue()))(_.protocol)
      .optionallyWith(
        subdirectory.map(value =>
          FsxOntapSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationFsxOntapRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationFsxOntapRequest.wrap(buildAwsValue())
}
object UpdateLocationFsxOntapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationFsxOntapRequest =
      zio.aws.datasync.model.UpdateLocationFsxOntapRequest(
        locationArn,
        protocol.map(value => value.asEditable),
        subdirectory.map(value => value)
      )
    def locationArn: LocationArn
    def protocol: Optional[zio.aws.datasync.model.FsxUpdateProtocol.ReadOnly]
    def subdirectory: Optional[FsxOntapSubdirectory]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.FsxUpdateProtocol.ReadOnly
    ] = AwsError.unwrapOptionField("protocol", protocol)
    def getSubdirectory: ZIO[Any, AwsError, FsxOntapSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest
  ) extends zio.aws.datasync.model.UpdateLocationFsxOntapRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val protocol
        : Optional[zio.aws.datasync.model.FsxUpdateProtocol.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.datasync.model.FsxUpdateProtocol.wrap(value))
    override val subdirectory: Optional[FsxOntapSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.FsxOntapSubdirectory(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOntapRequest
  ): zio.aws.datasync.model.UpdateLocationFsxOntapRequest.ReadOnly =
    new Wrapper(impl)
}
