package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{SmbSubdirectory, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationFsxOpenZfsRequest(
    locationArn: LocationArn,
    protocol: Optional[zio.aws.datasync.model.FsxProtocol] = Optional.Absent,
    subdirectory: Optional[SmbSubdirectory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest = {
    import UpdateLocationFsxOpenZfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(protocol.map(value => value.buildAwsValue()))(_.protocol)
      .optionallyWith(
        subdirectory.map(value =>
          SmbSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationFsxOpenZfsRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationFsxOpenZfsRequest.wrap(buildAwsValue())
}
object UpdateLocationFsxOpenZfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationFsxOpenZfsRequest =
      zio.aws.datasync.model.UpdateLocationFsxOpenZfsRequest(
        locationArn,
        protocol.map(value => value.asEditable),
        subdirectory.map(value => value)
      )
    def locationArn: LocationArn
    def protocol: Optional[zio.aws.datasync.model.FsxProtocol.ReadOnly]
    def subdirectory: Optional[SmbSubdirectory]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSubdirectory: ZIO[Any, AwsError, SmbSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest
  ) extends zio.aws.datasync.model.UpdateLocationFsxOpenZfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val protocol
        : Optional[zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.datasync.model.FsxProtocol.wrap(value))
    override val subdirectory: Optional[SmbSubdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.SmbSubdirectory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxOpenZfsRequest
  ): zio.aws.datasync.model.UpdateLocationFsxOpenZfsRequest.ReadOnly =
    new Wrapper(impl)
}
