package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  SmbUser,
  SmbPassword,
  UpdateSmbDomain,
  LocationArn,
  FsxWindowsSubdirectory
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationFsxWindowsRequest(
    locationArn: LocationArn,
    subdirectory: Optional[FsxWindowsSubdirectory] = Optional.Absent,
    domain: Optional[UpdateSmbDomain] = Optional.Absent,
    user: Optional[SmbUser] = Optional.Absent,
    password: Optional[SmbPassword] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest = {
    import UpdateLocationFsxWindowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          FsxWindowsSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        domain.map(value => UpdateSmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        password.map(value => SmbPassword.unwrap(value): java.lang.String)
      )(_.password)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationFsxWindowsRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationFsxWindowsRequest.wrap(buildAwsValue())
}
object UpdateLocationFsxWindowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationFsxWindowsRequest =
      zio.aws.datasync.model.UpdateLocationFsxWindowsRequest(
        locationArn,
        subdirectory.map(value => value),
        domain.map(value => value),
        user.map(value => value),
        password.map(value => value)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[FsxWindowsSubdirectory]
    def domain: Optional[UpdateSmbDomain]
    def user: Optional[SmbUser]
    def password: Optional[SmbPassword]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, FsxWindowsSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getDomain: ZIO[Any, AwsError, UpdateSmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getPassword: ZIO[Any, AwsError, SmbPassword] =
      AwsError.unwrapOptionField("password", password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest
  ) extends zio.aws.datasync.model.UpdateLocationFsxWindowsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[FsxWindowsSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.FsxWindowsSubdirectory(value)
        )
    override val domain: Optional[UpdateSmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.UpdateSmbDomain(value))
    override val user: Optional[SmbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val password: Optional[SmbPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.datasync.model.primitives.SmbPassword(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationFsxWindowsRequest
  ): zio.aws.datasync.model.UpdateLocationFsxWindowsRequest.ReadOnly =
    new Wrapper(impl)
}
