package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{S3Subdirectory, LocationArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationS3Request(
    locationArn: LocationArn,
    subdirectory: Optional[S3Subdirectory] = Optional.Absent,
    s3StorageClass: Optional[zio.aws.datasync.model.S3StorageClass] =
      Optional.Absent,
    s3Config: Optional[zio.aws.datasync.model.S3Config] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request = {
    import UpdateLocationS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(s3StorageClass.map(value => value.unwrap))(
        _.s3StorageClass
      )
      .optionallyWith(s3Config.map(value => value.buildAwsValue()))(_.s3Config)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateLocationS3Request.ReadOnly =
    zio.aws.datasync.model.UpdateLocationS3Request.wrap(buildAwsValue())
}
object UpdateLocationS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationS3Request =
      zio.aws.datasync.model.UpdateLocationS3Request(
        locationArn,
        subdirectory.map(value => value),
        s3StorageClass.map(value => value),
        s3Config.map(value => value.asEditable)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[S3Subdirectory]
    def s3StorageClass: Optional[zio.aws.datasync.model.S3StorageClass]
    def s3Config: Optional[zio.aws.datasync.model.S3Config.ReadOnly]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getS3StorageClass
        : ZIO[Any, AwsError, zio.aws.datasync.model.S3StorageClass] =
      AwsError.unwrapOptionField("s3StorageClass", s3StorageClass)
    def getS3Config
        : ZIO[Any, AwsError, zio.aws.datasync.model.S3Config.ReadOnly] =
      AwsError.unwrapOptionField("s3Config", s3Config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request
  ) extends zio.aws.datasync.model.UpdateLocationS3Request.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[S3Subdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val s3StorageClass
        : Optional[zio.aws.datasync.model.S3StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3StorageClass())
        .map(value => zio.aws.datasync.model.S3StorageClass.wrap(value))
    override val s3Config: Optional[zio.aws.datasync.model.S3Config.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Config())
        .map(value => zio.aws.datasync.model.S3Config.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationS3Request
  ): zio.aws.datasync.model.UpdateLocationS3Request.ReadOnly = new Wrapper(impl)
}
