package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  SmbUser,
  SmbSubdirectory,
  SmbPassword,
  LocationArn,
  KerberosKeytabFile,
  SmbDomain,
  KerberosPrincipal,
  KerberosKrb5ConfFile,
  ServerIpAddress,
  ServerHostname,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationSmbRequest(
    locationArn: LocationArn,
    subdirectory: Optional[SmbSubdirectory] = Optional.Absent,
    serverHostname: Optional[ServerHostname] = Optional.Absent,
    user: Optional[SmbUser] = Optional.Absent,
    domain: Optional[SmbDomain] = Optional.Absent,
    password: Optional[SmbPassword] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions] =
      Optional.Absent,
    authenticationType: Optional[zio.aws.datasync.model.SmbAuthenticationType] =
      Optional.Absent,
    dnsIpAddresses: Optional[Iterable[ServerIpAddress]] = Optional.Absent,
    kerberosPrincipal: Optional[KerberosPrincipal] = Optional.Absent,
    kerberosKeytab: Optional[KerberosKeytabFile] = Optional.Absent,
    kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest = {
    import UpdateLocationSmbRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          SmbSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        serverHostname.map(value =>
          ServerHostname.unwrap(value): java.lang.String
        )
      )(_.serverHostname)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        password.map(value => SmbPassword.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        dnsIpAddresses.map(value =>
          value.map { item =>
            ServerIpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIpAddresses)
      .optionallyWith(
        kerberosPrincipal.map(value =>
          KerberosPrincipal.unwrap(value): java.lang.String
        )
      )(_.kerberosPrincipal)
      .optionallyWith(
        kerberosKeytab.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKeytab)
      .optionallyWith(
        kerberosKrb5Conf.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKrb5Conf)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateLocationSmbRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationSmbRequest.wrap(buildAwsValue())
}
object UpdateLocationSmbRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationSmbRequest =
      zio.aws.datasync.model.UpdateLocationSmbRequest(
        locationArn,
        subdirectory.map(value => value),
        serverHostname.map(value => value),
        user.map(value => value),
        domain.map(value => value),
        password.map(value => value),
        agentArns.map(value => value),
        mountOptions.map(value => value.asEditable),
        authenticationType.map(value => value),
        dnsIpAddresses.map(value => value),
        kerberosPrincipal.map(value => value),
        kerberosKeytab.map(value => value),
        kerberosKrb5Conf.map(value => value)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[SmbSubdirectory]
    def serverHostname: Optional[ServerHostname]
    def user: Optional[SmbUser]
    def domain: Optional[SmbDomain]
    def password: Optional[SmbPassword]
    def agentArns: Optional[List[AgentArn]]
    def mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def authenticationType
        : Optional[zio.aws.datasync.model.SmbAuthenticationType]
    def dnsIpAddresses: Optional[List[ServerIpAddress]]
    def kerberosPrincipal: Optional[KerberosPrincipal]
    def kerberosKeytab: Optional[KerberosKeytabFile]
    def kerberosKrb5Conf: Optional[KerberosKrb5ConfFile]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, SmbSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getServerHostname: ZIO[Any, AwsError, ServerHostname] =
      AwsError.unwrapOptionField("serverHostname", serverHostname)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getPassword: ZIO[Any, AwsError, SmbPassword] =
      AwsError.unwrapOptionField("password", password)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbAuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getDnsIpAddresses: ZIO[Any, AwsError, List[ServerIpAddress]] =
      AwsError.unwrapOptionField("dnsIpAddresses", dnsIpAddresses)
    def getKerberosPrincipal: ZIO[Any, AwsError, KerberosPrincipal] =
      AwsError.unwrapOptionField("kerberosPrincipal", kerberosPrincipal)
    def getKerberosKeytab: ZIO[Any, AwsError, KerberosKeytabFile] =
      AwsError.unwrapOptionField("kerberosKeytab", kerberosKeytab)
    def getKerberosKrb5Conf: ZIO[Any, AwsError, KerberosKrb5ConfFile] =
      AwsError.unwrapOptionField("kerberosKrb5Conf", kerberosKrb5Conf)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
  ) extends zio.aws.datasync.model.UpdateLocationSmbRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[SmbSubdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.SmbSubdirectory(value))
    override val serverHostname: Optional[ServerHostname] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverHostname())
        .map(value => zio.aws.datasync.model.primitives.ServerHostname(value))
    override val user: Optional[SmbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Optional[SmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val password: Optional[SmbPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.datasync.model.primitives.SmbPassword(value))
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val mountOptions
        : Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val authenticationType
        : Optional[zio.aws.datasync.model.SmbAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.datasync.model.SmbAuthenticationType.wrap(value))
    override val dnsIpAddresses: Optional[List[ServerIpAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.ServerIpAddress(item)
          }.toList
        )
    override val kerberosPrincipal: Optional[KerberosPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosPrincipal())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosPrincipal(value)
        )
    override val kerberosKeytab: Optional[KerberosKeytabFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKeytab())
        .map(value =>
          zio.aws.datasync.model.primitives
            .KerberosKeytabFile(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKrb5Conf())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosKrb5ConfFile(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
  ): zio.aws.datasync.model.UpdateLocationSmbRequest.ReadOnly = new Wrapper(
    impl
  )
}
