package zio.aws.datasync
import zio.aws.datasync.model.primitives.ServerHostname.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  PtolemyString,
  FilterAttributeValue,
  Ec2SubnetArn,
  ServerIpAddress,
  NetworkInterfaceArn,
  ResourceId,
  AgentArn,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActivationKey extends zio.prelude.Subtype[String]
    type ActivationKey = zio.aws.datasync.model.primitives.ActivationKey.Type
    object AgentArn extends zio.prelude.Subtype[String]
    type AgentArn = zio.aws.datasync.model.primitives.AgentArn.Type
    object AgentVersion extends zio.prelude.Subtype[String]
    type AgentVersion = zio.aws.datasync.model.primitives.AgentVersion.Type
    object AzureBlobContainerUrl extends zio.prelude.Subtype[String]
    type AzureBlobContainerUrl =
      zio.aws.datasync.model.primitives.AzureBlobContainerUrl.Type
    object AzureBlobSasToken extends zio.prelude.Subtype[String]
    type AzureBlobSasToken =
      zio.aws.datasync.model.primitives.AzureBlobSasToken.Type
    object AzureBlobSubdirectory extends zio.prelude.Subtype[String]
    type AzureBlobSubdirectory =
      zio.aws.datasync.model.primitives.AzureBlobSubdirectory.Type
    object BytesPerSecond extends zio.prelude.Subtype[Long]
    type BytesPerSecond = zio.aws.datasync.model.primitives.BytesPerSecond.Type
    object CollectionDurationMinutes extends zio.prelude.Subtype[Int]
    type CollectionDurationMinutes =
      zio.aws.datasync.model.primitives.CollectionDurationMinutes.Type
    object DiscoveryJobArn extends zio.prelude.Subtype[String]
    type DiscoveryJobArn =
      zio.aws.datasync.model.primitives.DiscoveryJobArn.Type
    object DiscoveryMaxResults extends zio.prelude.Subtype[Int]
    type DiscoveryMaxResults =
      zio.aws.datasync.model.primitives.DiscoveryMaxResults.Type
    object DiscoveryNextToken extends zio.prelude.Subtype[String]
    type DiscoveryNextToken =
      zio.aws.datasync.model.primitives.DiscoveryNextToken.Type
    object DiscoveryServerHostname extends zio.prelude.Subtype[String]
    type DiscoveryServerHostname =
      zio.aws.datasync.model.primitives.DiscoveryServerHostname.Type
    object DiscoveryServerPort extends zio.prelude.Subtype[Int]
    type DiscoveryServerPort =
      zio.aws.datasync.model.primitives.DiscoveryServerPort.Type
    object DiscoveryTime extends zio.prelude.Subtype[Instant]
    type DiscoveryTime = zio.aws.datasync.model.primitives.DiscoveryTime.Type
    object Duration extends zio.prelude.Subtype[Long]
    type Duration = zio.aws.datasync.model.primitives.Duration.Type
    object Ec2SecurityGroupArn extends zio.prelude.Subtype[String]
    type Ec2SecurityGroupArn =
      zio.aws.datasync.model.primitives.Ec2SecurityGroupArn.Type
    object Ec2SubnetArn extends zio.prelude.Subtype[String]
    type Ec2SubnetArn = zio.aws.datasync.model.primitives.Ec2SubnetArn.Type
    object EfsAccessPointArn extends zio.prelude.Subtype[String]
    type EfsAccessPointArn =
      zio.aws.datasync.model.primitives.EfsAccessPointArn.Type
    object EfsFilesystemArn extends zio.prelude.Subtype[String]
    type EfsFilesystemArn =
      zio.aws.datasync.model.primitives.EfsFilesystemArn.Type
    object EfsSubdirectory extends zio.prelude.Subtype[String]
    type EfsSubdirectory =
      zio.aws.datasync.model.primitives.EfsSubdirectory.Type
    object Endpoint extends zio.prelude.Subtype[String]
    type Endpoint = zio.aws.datasync.model.primitives.Endpoint.Type
    object ErrorMessage extends zio.prelude.Subtype[String]
    type ErrorMessage = zio.aws.datasync.model.primitives.ErrorMessage.Type
    object FilterAttributeValue extends zio.prelude.Subtype[String]
    type FilterAttributeValue =
      zio.aws.datasync.model.primitives.FilterAttributeValue.Type
    object FilterValue extends zio.prelude.Subtype[String]
    type FilterValue = zio.aws.datasync.model.primitives.FilterValue.Type
    object FsxFilesystemArn extends zio.prelude.Subtype[String]
    type FsxFilesystemArn =
      zio.aws.datasync.model.primitives.FsxFilesystemArn.Type
    object FsxLustreSubdirectory extends zio.prelude.Subtype[String]
    type FsxLustreSubdirectory =
      zio.aws.datasync.model.primitives.FsxLustreSubdirectory.Type
    object FsxOntapSubdirectory extends zio.prelude.Subtype[String]
    type FsxOntapSubdirectory =
      zio.aws.datasync.model.primitives.FsxOntapSubdirectory.Type
    object FsxOpenZfsSubdirectory extends zio.prelude.Subtype[String]
    type FsxOpenZfsSubdirectory =
      zio.aws.datasync.model.primitives.FsxOpenZfsSubdirectory.Type
    object FsxWindowsSubdirectory extends zio.prelude.Subtype[String]
    type FsxWindowsSubdirectory =
      zio.aws.datasync.model.primitives.FsxWindowsSubdirectory.Type
    object HdfsBlockSize extends zio.prelude.Subtype[Int]
    type HdfsBlockSize = zio.aws.datasync.model.primitives.HdfsBlockSize.Type
    object HdfsReplicationFactor extends zio.prelude.Subtype[Int]
    type HdfsReplicationFactor =
      zio.aws.datasync.model.primitives.HdfsReplicationFactor.Type
    object HdfsServerHostname extends zio.prelude.Subtype[String]
    type HdfsServerHostname =
      zio.aws.datasync.model.primitives.HdfsServerHostname.Type
    object HdfsServerPort extends zio.prelude.Subtype[Int]
    type HdfsServerPort = zio.aws.datasync.model.primitives.HdfsServerPort.Type
    object HdfsSubdirectory extends zio.prelude.Subtype[String]
    type HdfsSubdirectory =
      zio.aws.datasync.model.primitives.HdfsSubdirectory.Type
    object HdfsUser extends zio.prelude.Subtype[String]
    type HdfsUser = zio.aws.datasync.model.primitives.HdfsUser.Type
    object IamRoleArn extends zio.prelude.Subtype[String]
    type IamRoleArn = zio.aws.datasync.model.primitives.IamRoleArn.Type
    object KerberosKeytabFile extends zio.prelude.Subtype[Chunk[Byte]]
    type KerberosKeytabFile =
      zio.aws.datasync.model.primitives.KerberosKeytabFile.Type
    object KerberosKrb5ConfFile extends zio.prelude.Subtype[Chunk[Byte]]
    type KerberosKrb5ConfFile =
      zio.aws.datasync.model.primitives.KerberosKrb5ConfFile.Type
    object KerberosPrincipal extends zio.prelude.Subtype[String]
    type KerberosPrincipal =
      zio.aws.datasync.model.primitives.KerberosPrincipal.Type
    object KmsKeyProviderUri extends zio.prelude.Subtype[String]
    type KmsKeyProviderUri =
      zio.aws.datasync.model.primitives.KmsKeyProviderUri.Type
    object LocationArn extends zio.prelude.Subtype[String]
    type LocationArn = zio.aws.datasync.model.primitives.LocationArn.Type
    object LocationUri extends zio.prelude.Subtype[String]
    type LocationUri = zio.aws.datasync.model.primitives.LocationUri.Type
    object LogGroupArn extends zio.prelude.Subtype[String]
    type LogGroupArn = zio.aws.datasync.model.primitives.LogGroupArn.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.datasync.model.primitives.MaxResults.Type
    object Name extends zio.prelude.Subtype[String]
    type Name = zio.aws.datasync.model.primitives.Name.Type
    object NetworkInterfaceArn extends zio.prelude.Subtype[String]
    type NetworkInterfaceArn =
      zio.aws.datasync.model.primitives.NetworkInterfaceArn.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.datasync.model.primitives.NextToken.Type
    object NfsSubdirectory extends zio.prelude.Subtype[String]
    type NfsSubdirectory =
      zio.aws.datasync.model.primitives.NfsSubdirectory.Type
    object NonNegativeDouble extends zio.prelude.Subtype[Double]
    type NonNegativeDouble =
      zio.aws.datasync.model.primitives.NonNegativeDouble.Type
    object NonNegativeLong extends zio.prelude.Subtype[Long]
    type NonNegativeLong =
      zio.aws.datasync.model.primitives.NonNegativeLong.Type
    object ObjectStorageAccessKey extends zio.prelude.Subtype[String]
    type ObjectStorageAccessKey =
      zio.aws.datasync.model.primitives.ObjectStorageAccessKey.Type
    object ObjectStorageBucketName extends zio.prelude.Subtype[String]
    type ObjectStorageBucketName =
      zio.aws.datasync.model.primitives.ObjectStorageBucketName.Type
    object ObjectStorageCertificate extends zio.prelude.Subtype[Chunk[Byte]]
    type ObjectStorageCertificate =
      zio.aws.datasync.model.primitives.ObjectStorageCertificate.Type
    object ObjectStorageSecretKey extends zio.prelude.Subtype[String]
    type ObjectStorageSecretKey =
      zio.aws.datasync.model.primitives.ObjectStorageSecretKey.Type
    object ObjectStorageServerPort extends zio.prelude.Subtype[Int]
    type ObjectStorageServerPort =
      zio.aws.datasync.model.primitives.ObjectStorageServerPort.Type
    object PtolemyBoolean extends zio.prelude.Subtype[Boolean]
    type PtolemyBoolean = zio.aws.datasync.model.primitives.PtolemyBoolean.Type
    object PtolemyPassword extends zio.prelude.Subtype[String]
    type PtolemyPassword =
      zio.aws.datasync.model.primitives.PtolemyPassword.Type
    object PtolemyString extends zio.prelude.Subtype[String]
    type PtolemyString = zio.aws.datasync.model.primitives.PtolemyString.Type
    object PtolemyUUID extends zio.prelude.Subtype[String]
    type PtolemyUUID = zio.aws.datasync.model.primitives.PtolemyUUID.Type
    object PtolemyUsername extends zio.prelude.Subtype[String]
    type PtolemyUsername =
      zio.aws.datasync.model.primitives.PtolemyUsername.Type
    object ResourceId extends zio.prelude.Subtype[String]
    type ResourceId = zio.aws.datasync.model.primitives.ResourceId.Type
    object S3BucketArn extends zio.prelude.Subtype[String]
    type S3BucketArn = zio.aws.datasync.model.primitives.S3BucketArn.Type
    object S3ObjectVersionId extends zio.prelude.Subtype[String]
    type S3ObjectVersionId =
      zio.aws.datasync.model.primitives.S3ObjectVersionId.Type
    object S3Subdirectory extends zio.prelude.Subtype[String]
    type S3Subdirectory = zio.aws.datasync.model.primitives.S3Subdirectory.Type
    object ScheduleDisabledReason extends zio.prelude.Subtype[String]
    type ScheduleDisabledReason =
      zio.aws.datasync.model.primitives.ScheduleDisabledReason.Type
    object ScheduleExpressionCron extends zio.prelude.Subtype[String]
    type ScheduleExpressionCron =
      zio.aws.datasync.model.primitives.ScheduleExpressionCron.Type
    object SecretsManagerArn extends zio.prelude.Subtype[String]
    type SecretsManagerArn =
      zio.aws.datasync.model.primitives.SecretsManagerArn.Type
    object ServerHostname extends zio.prelude.Subtype[String]
    type ServerHostname = zio.aws.datasync.model.primitives.ServerHostname.Type
    object ServerIpAddress extends zio.prelude.Subtype[String]
    type ServerIpAddress =
      zio.aws.datasync.model.primitives.ServerIpAddress.Type
    object SmbDomain extends zio.prelude.Subtype[String]
    type SmbDomain = zio.aws.datasync.model.primitives.SmbDomain.Type
    object SmbPassword extends zio.prelude.Subtype[String]
    type SmbPassword = zio.aws.datasync.model.primitives.SmbPassword.Type
    object SmbSubdirectory extends zio.prelude.Subtype[String]
    type SmbSubdirectory =
      zio.aws.datasync.model.primitives.SmbSubdirectory.Type
    object SmbUser extends zio.prelude.Subtype[String]
    type SmbUser = zio.aws.datasync.model.primitives.SmbUser.Type
    object StorageSystemArn extends zio.prelude.Subtype[String]
    type StorageSystemArn =
      zio.aws.datasync.model.primitives.StorageSystemArn.Type
    object StorageVirtualMachineArn extends zio.prelude.Subtype[String]
    type StorageVirtualMachineArn =
      zio.aws.datasync.model.primitives.StorageVirtualMachineArn.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.datasync.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.datasync.model.primitives.TagValue.Type
    object TaggableResourceArn extends zio.prelude.Subtype[String]
    type TaggableResourceArn =
      zio.aws.datasync.model.primitives.TaggableResourceArn.Type
    object TaskArn extends zio.prelude.Subtype[String]
    type TaskArn = zio.aws.datasync.model.primitives.TaskArn.Type
    object TaskExecutionArn extends zio.prelude.Subtype[String]
    type TaskExecutionArn =
      zio.aws.datasync.model.primitives.TaskExecutionArn.Type
    object Time extends zio.prelude.Subtype[Instant]
    type Time = zio.aws.datasync.model.primitives.Time.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.datasync.model.primitives.Timestamp.Type
    object UpdateSmbDomain extends zio.prelude.Subtype[String]
    type UpdateSmbDomain =
      zio.aws.datasync.model.primitives.UpdateSmbDomain.Type
    object UpdatedEfsAccessPointArn extends zio.prelude.Subtype[String]
    type UpdatedEfsAccessPointArn =
      zio.aws.datasync.model.primitives.UpdatedEfsAccessPointArn.Type
    object UpdatedEfsIamRoleArn extends zio.prelude.Subtype[String]
    type UpdatedEfsIamRoleArn =
      zio.aws.datasync.model.primitives.UpdatedEfsIamRoleArn.Type
    object VpcEndpointId extends zio.prelude.Subtype[String]
    type VpcEndpointId = zio.aws.datasync.model.primitives.VpcEndpointId.Type
  }
  type AgentArnList = List[AgentArn]
  type AgentList = List[zio.aws.datasync.model.AgentListEntry]
  type DestinationNetworkInterfaceArns = List[NetworkInterfaceArn]
  type DiscoveryAgentArnList = List[AgentArn]
  type DiscoveryJobList = List[zio.aws.datasync.model.DiscoveryJobListEntry]
  type DnsIpList = List[ServerIpAddress]
  type Ec2SecurityGroupArnList = List[Ec2SecurityGroupArn]
  type EnabledProtocols = List[PtolemyString]
  type FilterList = List[zio.aws.datasync.model.FilterRule]
  type FilterMembers = List[PtolemyString]
  type FilterValues = List[FilterAttributeValue]
  type HdfsNameNodeList = List[zio.aws.datasync.model.HdfsNameNode]
  type InputTagList = List[zio.aws.datasync.model.TagListEntry]
  type LocationFilters = List[zio.aws.datasync.model.LocationFilter]
  type LocationList = List[zio.aws.datasync.model.LocationListEntry]
  type Metrics = List[zio.aws.datasync.model.ResourceMetrics]
  type NetAppONTAPClusters = List[zio.aws.datasync.model.NetAppONTAPCluster]
  type NetAppONTAPSVMs = List[zio.aws.datasync.model.NetAppONTAPSVM]
  type NetAppONTAPVolumes = List[zio.aws.datasync.model.NetAppONTAPVolume]
  type OutputTagList = List[zio.aws.datasync.model.TagListEntry]
  type PLSecurityGroupArnList = List[Ec2SecurityGroupArn]
  type PLSubnetArnList = List[Ec2SubnetArn]
  type Recommendations = List[zio.aws.datasync.model.Recommendation]
  type RecommendationsConfigMap = Map[PtolemyString, PtolemyString]
  type ResourceFilters =
    Map[zio.aws.datasync.model.DiscoveryResourceFilter, Iterable[PtolemyString]]
  type ResourceIds = List[ResourceId]
  type SourceNetworkInterfaceArns = List[NetworkInterfaceArn]
  type StorageSystemList = List[zio.aws.datasync.model.StorageSystemListEntry]
  type TagKeyList = List[TagKey]
  type TaskExecutionList = List[zio.aws.datasync.model.TaskExecutionListEntry]
  type TaskFilters = List[zio.aws.datasync.model.TaskFilter]
  type TaskList = List[zio.aws.datasync.model.TaskListEntry]
}
