package zio.aws.deadline
import zio.aws.deadline.model.ListSessionsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.deadline.{
  DeadlineAsyncClientBuilder,
  DeadlineAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.deadline.model.{
  CreateQueueResponse,
  ListBudgetsResponse,
  UpdateFarmRequest,
  GetBudgetRequest,
  GetFarmResponse,
  LicenseEndpointSummary,
  UpdateWorkerResponse,
  GetStepResponse,
  ListFleetsRequest,
  CreateLicenseEndpointResponse,
  FarmSummary,
  GetFleetResponse,
  StepDependency,
  SearchStepsRequest,
  ListWorkersRequest,
  MeteredProductSummary,
  UpdateSessionRequest,
  CreateBudgetResponse,
  UpdateQueueEnvironmentRequest,
  ListStepsResponse,
  ListFarmMembersResponse,
  ListMonitorsResponse,
  AssumeFleetRoleForReadRequest,
  ListQueueFleetAssociationsResponse,
  ListQueuesRequest,
  DeleteQueueRequest,
  DeleteMonitorResponse,
  GetFleetRequest,
  CreateFleetResponse,
  ListFarmsRequest,
  AssumeFleetRoleForWorkerResponse,
  BudgetSummary,
  ListStepDependenciesRequest,
  ListJobParameterDefinitionsRequest,
  GetLicenseEndpointResponse,
  DeleteBudgetRequest,
  GetStepRequest,
  GetMonitorResponse,
  DeleteLicenseEndpointRequest,
  GetLicenseEndpointRequest,
  FleetMember,
  SearchJobsResponse,
  ListTasksResponse,
  SessionSummary,
  DeleteFleetResponse,
  ListStepDependenciesResponse,
  UpdateQueueFleetAssociationRequest,
  ListSessionsResponse,
  StorageProfileSummary,
  GetStorageProfileResponse,
  UpdateQueueRequest,
  SearchTasksResponse,
  GetQueueEnvironmentRequest,
  SearchWorkersResponse,
  ListJobsRequest,
  ListQueueMembersResponse,
  DeleteMonitorRequest,
  GetTaskRequest,
  BatchGetJobEntityResponse,
  ListQueueMembersRequest,
  AssumeQueueRoleForWorkerResponse,
  GetJobRequest,
  ListSessionActionsResponse,
  StartSessionsStatisticsAggregationRequest,
  UpdateFarmResponse,
  CreateQueueRequest,
  UpdateStepRequest,
  ListStorageProfilesResponse,
  ListFleetsResponse,
  ListFleetMembersResponse,
  CreateQueueEnvironmentRequest,
  DeleteMeteredProductRequest,
  CreateFarmResponse,
  ListJobParameterDefinitionsResponse,
  SearchWorkersRequest,
  DeleteWorkerRequest,
  ListTagsForResourceRequest,
  AssumeQueueRoleForReadResponse,
  DeleteStorageProfileResponse,
  ListStepsRequest,
  UpdateStorageProfileRequest,
  DeleteQueueEnvironmentResponse,
  PutMeteredProductResponse,
  DisassociateMemberFromFleetRequest,
  FarmMember,
  DeleteQueueResponse,
  ListLicenseEndpointsResponse,
  TaskSummary,
  GetStorageProfileForQueueRequest,
  StepSummary,
  QueueSummary,
  WorkerSessionSummary,
  QueueEnvironmentSummary,
  ListAvailableMeteredProductsRequest,
  ListFleetMembersRequest,
  WorkerSummary,
  GetJobResponse,
  GetQueueResponse,
  CreateLicenseEndpointRequest,
  UpdateQueueResponse,
  ListStepConsumersResponse,
  ListTagsForResourceResponse,
  UpdateJobResponse,
  CreateWorkerRequest,
  UntagResourceResponse,
  AssumeQueueRoleForReadRequest,
  DisassociateMemberFromFleetResponse,
  PutMeteredProductRequest,
  CopyJobTemplateRequest,
  ListMonitorsRequest,
  DeleteFarmRequest,
  DeleteLicenseEndpointResponse,
  DisassociateMemberFromFarmRequest,
  ListSessionsForWorkerRequest,
  ListBudgetsRequest,
  ListLicenseEndpointsRequest,
  JobMember,
  StepConsumer,
  ListQueuesResponse,
  UpdateMonitorResponse,
  DeleteFarmResponse,
  AssociateMemberToQueueResponse,
  GetWorkerRequest,
  ListSessionsRequest,
  UpdateBudgetRequest,
  AssociateMemberToJobRequest,
  GetWorkerResponse,
  ListJobMembersRequest,
  MonitorSummary,
  ListMeteredProductsRequest,
  UpdateWorkerScheduleRequest,
  BatchGetJobEntityRequest,
  AssociateMemberToFleetResponse,
  DeleteStorageProfileRequest,
  ListTasksRequest,
  AssociateMemberToFleetRequest,
  ListMeteredProductsResponse,
  UpdateFleetRequest,
  CreateFleetRequest,
  CopyJobTemplateResponse,
  DisassociateMemberFromQueueResponse,
  ListSessionsForWorkerResponse,
  SearchStepsResponse,
  GetStorageProfileRequest,
  DisassociateMemberFromJobResponse,
  CreateStorageProfileResponse,
  UpdateMonitorRequest,
  GetQueueFleetAssociationResponse,
  ListWorkersResponse,
  AssumeFleetRoleForWorkerRequest,
  AssociateMemberToJobResponse,
  GetSessionRequest,
  GetSessionActionRequest,
  GetQueueFleetAssociationRequest,
  QueueFleetAssociationSummary,
  UpdateQueueEnvironmentResponse,
  UpdateQueueFleetAssociationResponse,
  UntagResourceRequest,
  GetQueueRequest,
  DisassociateMemberFromJobRequest,
  UpdateWorkerRequest,
  UpdateSessionResponse,
  ListStorageProfilesForQueueResponse,
  CreateJobRequest,
  ListStorageProfilesForQueueRequest,
  ListFarmMembersRequest,
  GetTaskResponse,
  ListQueueEnvironmentsRequest,
  StartSessionsStatisticsAggregationResponse,
  UpdateJobRequest,
  AssumeQueueRoleForUserRequest,
  ListStorageProfilesRequest,
  UpdateStorageProfileResponse,
  AssociateMemberToQueueRequest,
  UpdateWorkerScheduleResponse,
  DeleteWorkerResponse,
  GetSessionResponse,
  SearchJobsRequest,
  AssumeQueueRoleForWorkerRequest,
  GetStorageProfileForQueueResponse,
  DeleteQueueFleetAssociationResponse,
  ListJobMembersResponse,
  GetBudgetResponse,
  CreateWorkerResponse,
  ListJobsResponse,
  UpdateBudgetResponse,
  CreateStorageProfileRequest,
  ListAvailableMeteredProductsResponse,
  CreateQueueEnvironmentResponse,
  GetMonitorRequest,
  ListQueueFleetAssociationsRequest,
  GetFarmRequest,
  GetSessionsStatisticsAggregationResponse,
  ListStepConsumersRequest,
  CreateQueueFleetAssociationRequest,
  ListSessionActionsRequest,
  DisassociateMemberFromFarmResponse,
  AssociateMemberToFarmRequest,
  AssociateMemberToFarmResponse,
  UpdateTaskResponse,
  SearchTasksRequest,
  AssumeFleetRoleForReadResponse,
  FleetSummary,
  AssumeQueueRoleForUserResponse,
  TagResourceResponse,
  CreateQueueFleetAssociationResponse,
  GetQueueEnvironmentResponse,
  CreateBudgetRequest,
  DeleteQueueEnvironmentRequest,
  CreateFarmRequest,
  GetSessionsStatisticsAggregationRequest,
  ListQueueEnvironmentsResponse,
  UpdateTaskRequest,
  ListFarmsResponse,
  DeleteBudgetResponse,
  DeleteQueueFleetAssociationRequest,
  UpdateFleetResponse,
  CreateMonitorResponse,
  SessionActionSummary,
  JobSummary,
  TagResourceRequest,
  DisassociateMemberFromQueueRequest,
  DeleteFleetRequest,
  GetSessionActionResponse,
  Statistics,
  QueueMember,
  DeleteMeteredProductResponse,
  CreateJobResponse,
  UpdateStepResponse,
  CreateMonitorRequest
}
import software.amazon.awssdk.services.deadline.paginators.{
  ListStorageProfilesPublisher,
  ListStepsPublisher,
  ListFarmMembersPublisher,
  ListQueueMembersPublisher,
  ListAvailableMeteredProductsPublisher,
  ListTasksPublisher,
  ListWorkersPublisher,
  ListQueuesPublisher,
  ListJobMembersPublisher,
  ListFleetMembersPublisher,
  ListMonitorsPublisher,
  GetSessionsStatisticsAggregationPublisher,
  ListMeteredProductsPublisher,
  ListQueueFleetAssociationsPublisher,
  ListSessionsPublisher,
  ListSessionsForWorkerPublisher,
  ListFarmsPublisher,
  ListStepDependenciesPublisher,
  ListFleetsPublisher,
  ListSessionActionsPublisher,
  ListBudgetsPublisher,
  ListJobsPublisher,
  ListStepConsumersPublisher,
  ListStorageProfilesForQueuePublisher,
  ListJobParameterDefinitionsPublisher,
  ListQueueEnvironmentsPublisher,
  ListLicenseEndpointsPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.core.document.Document
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Deadline extends AspectSupport[Deadline] {
  val api: DeadlineAsyncClient
  def associateMemberToFleet(
      request: zio.aws.deadline.model.AssociateMemberToFleetRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssociateMemberToFleetResponse.ReadOnly
  ]
  def listMonitors(
      request: zio.aws.deadline.model.ListMonitorsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.MonitorSummary.ReadOnly]
  def listMonitorsPaginated(
      request: zio.aws.deadline.model.ListMonitorsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListMonitorsResponse.ReadOnly]
  def updateQueue(
      request: zio.aws.deadline.model.UpdateQueueRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateQueueResponse.ReadOnly]
  def associateMemberToQueue(
      request: zio.aws.deadline.model.AssociateMemberToQueueRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssociateMemberToQueueResponse.ReadOnly
  ]
  def deleteWorker(
      request: zio.aws.deadline.model.DeleteWorkerRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteWorkerResponse.ReadOnly]
  def searchSteps(
      request: zio.aws.deadline.model.SearchStepsRequest
  ): IO[AwsError, zio.aws.deadline.model.SearchStepsResponse.ReadOnly]
  def updateQueueEnvironment(
      request: zio.aws.deadline.model.UpdateQueueEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.UpdateQueueEnvironmentResponse.ReadOnly
  ]
  def getBudget(
      request: zio.aws.deadline.model.GetBudgetRequest
  ): IO[AwsError, zio.aws.deadline.model.GetBudgetResponse.ReadOnly]
  def getFarm(
      request: zio.aws.deadline.model.GetFarmRequest
  ): IO[AwsError, zio.aws.deadline.model.GetFarmResponse.ReadOnly]
  def startSessionsStatisticsAggregation(
      request: zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly
  ]
  def createLicenseEndpoint(
      request: zio.aws.deadline.model.CreateLicenseEndpointRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly]
  def updateMonitor(
      request: zio.aws.deadline.model.UpdateMonitorRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateMonitorResponse.ReadOnly]
  def listFleetMembers(
      request: zio.aws.deadline.model.ListFleetMembersRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.FleetMember.ReadOnly]
  def listFleetMembersPaginated(
      request: zio.aws.deadline.model.ListFleetMembersRequest
  ): IO[AwsError, zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly]
  def getQueueEnvironment(
      request: zio.aws.deadline.model.GetQueueEnvironmentRequest
  ): IO[AwsError, zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly]
  def putMeteredProduct(
      request: zio.aws.deadline.model.PutMeteredProductRequest
  ): IO[AwsError, zio.aws.deadline.model.PutMeteredProductResponse.ReadOnly]
  def listStorageProfiles(
      request: zio.aws.deadline.model.ListStorageProfilesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.StorageProfileSummary.ReadOnly
  ]
  def listStorageProfilesPaginated(
      request: zio.aws.deadline.model.ListStorageProfilesRequest
  ): IO[AwsError, zio.aws.deadline.model.ListStorageProfilesResponse.ReadOnly]
  def createWorker(
      request: zio.aws.deadline.model.CreateWorkerRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateWorkerResponse.ReadOnly]
  def updateWorkerSchedule(
      request: zio.aws.deadline.model.UpdateWorkerScheduleRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly]
  def listFarms(
      request: zio.aws.deadline.model.ListFarmsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.FarmSummary.ReadOnly]
  def listFarmsPaginated(
      request: zio.aws.deadline.model.ListFarmsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListFarmsResponse.ReadOnly]
  def createStorageProfile(
      request: zio.aws.deadline.model.CreateStorageProfileRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly]
  def deleteBudget(
      request: zio.aws.deadline.model.DeleteBudgetRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteBudgetResponse.ReadOnly]
  def createBudget(
      request: zio.aws.deadline.model.CreateBudgetRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateBudgetResponse.ReadOnly]
  def disassociateMemberFromFarm(
      request: zio.aws.deadline.model.DisassociateMemberFromFarmRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromFarmResponse.ReadOnly
  ]
  def assumeQueueRoleForRead(
      request: zio.aws.deadline.model.AssumeQueueRoleForReadRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly
  ]
  def disassociateMemberFromQueue(
      request: zio.aws.deadline.model.DisassociateMemberFromQueueRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromQueueResponse.ReadOnly
  ]
  def getStep(
      request: zio.aws.deadline.model.GetStepRequest
  ): IO[AwsError, zio.aws.deadline.model.GetStepResponse.ReadOnly]
  def listFleets(
      request: zio.aws.deadline.model.ListFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.FleetSummary.ReadOnly]
  def listFleetsPaginated(
      request: zio.aws.deadline.model.ListFleetsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListFleetsResponse.ReadOnly]
  def disassociateMemberFromFleet(
      request: zio.aws.deadline.model.DisassociateMemberFromFleetRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromFleetResponse.ReadOnly
  ]
  def listQueues(
      request: zio.aws.deadline.model.ListQueuesRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.QueueSummary.ReadOnly]
  def listQueuesPaginated(
      request: zio.aws.deadline.model.ListQueuesRequest
  ): IO[AwsError, zio.aws.deadline.model.ListQueuesResponse.ReadOnly]
  def assumeFleetRoleForWorker(
      request: zio.aws.deadline.model.AssumeFleetRoleForWorkerRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssumeFleetRoleForWorkerResponse.ReadOnly
  ]
  def listQueueEnvironments(
      request: zio.aws.deadline.model.ListQueueEnvironmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly
  ]
  def listQueueEnvironmentsPaginated(
      request: zio.aws.deadline.model.ListQueueEnvironmentsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly]
  def updateQueueFleetAssociation(
      request: zio.aws.deadline.model.UpdateQueueFleetAssociationRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.UpdateQueueFleetAssociationResponse.ReadOnly
  ]
  def listLicenseEndpoints(
      request: zio.aws.deadline.model.ListLicenseEndpointsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly
  ]
  def listLicenseEndpointsPaginated(
      request: zio.aws.deadline.model.ListLicenseEndpointsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly]
  def listStorageProfilesForQueue(
      request: zio.aws.deadline.model.ListStorageProfilesForQueueRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.StorageProfileSummary.ReadOnly
  ]
  def listStorageProfilesForQueuePaginated(
      request: zio.aws.deadline.model.ListStorageProfilesForQueueRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly
  ]
  def listJobMembers(
      request: zio.aws.deadline.model.ListJobMembersRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.JobMember.ReadOnly]
  def listJobMembersPaginated(
      request: zio.aws.deadline.model.ListJobMembersRequest
  ): IO[AwsError, zio.aws.deadline.model.ListJobMembersResponse.ReadOnly]
  def createJob(
      request: zio.aws.deadline.model.CreateJobRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateJobResponse.ReadOnly]
  def deleteMonitor(
      request: zio.aws.deadline.model.DeleteMonitorRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteMonitorResponse.ReadOnly]
  def updateBudget(
      request: zio.aws.deadline.model.UpdateBudgetRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateBudgetResponse.ReadOnly]
  def getSessionsStatisticsAggregation(
      request: zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.Statistics.ReadOnly]
  def getSessionsStatisticsAggregationPaginated(
      request: zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly
  ]
  def createFarm(
      request: zio.aws.deadline.model.CreateFarmRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateFarmResponse.ReadOnly]
  def createQueueFleetAssociation(
      request: zio.aws.deadline.model.CreateQueueFleetAssociationRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.CreateQueueFleetAssociationResponse.ReadOnly
  ]
  def searchTasks(
      request: zio.aws.deadline.model.SearchTasksRequest
  ): IO[AwsError, zio.aws.deadline.model.SearchTasksResponse.ReadOnly]
  def deleteFleet(
      request: zio.aws.deadline.model.DeleteFleetRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteFleetResponse.ReadOnly]
  def updateStorageProfile(
      request: zio.aws.deadline.model.UpdateStorageProfileRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateStorageProfileResponse.ReadOnly]
  def createMonitor(
      request: zio.aws.deadline.model.CreateMonitorRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateMonitorResponse.ReadOnly]
  def listFarmMembers(
      request: zio.aws.deadline.model.ListFarmMembersRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.FarmMember.ReadOnly]
  def listFarmMembersPaginated(
      request: zio.aws.deadline.model.ListFarmMembersRequest
  ): IO[AwsError, zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly]
  def getStorageProfileForQueue(
      request: zio.aws.deadline.model.GetStorageProfileForQueueRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly
  ]
  def searchJobs(
      request: zio.aws.deadline.model.SearchJobsRequest
  ): IO[AwsError, zio.aws.deadline.model.SearchJobsResponse.ReadOnly]
  def updateFleet(
      request: zio.aws.deadline.model.UpdateFleetRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateFleetResponse.ReadOnly]
  def getFleet(
      request: zio.aws.deadline.model.GetFleetRequest
  ): IO[AwsError, zio.aws.deadline.model.GetFleetResponse.ReadOnly]
  def listSessionsForWorker(
      request: zio.aws.deadline.model.ListSessionsForWorkerRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.WorkerSessionSummary.ReadOnly
  ]
  def listSessionsForWorkerPaginated(
      request: zio.aws.deadline.model.ListSessionsForWorkerRequest
  ): IO[AwsError, zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly]
  def updateStep(
      request: zio.aws.deadline.model.UpdateStepRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateStepResponse.ReadOnly]
  def listSteps(
      request: zio.aws.deadline.model.ListStepsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.StepSummary.ReadOnly]
  def listStepsPaginated(
      request: zio.aws.deadline.model.ListStepsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListStepsResponse.ReadOnly]
  def createFleet(
      request: zio.aws.deadline.model.CreateFleetRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateFleetResponse.ReadOnly]
  def searchWorkers(
      request: zio.aws.deadline.model.SearchWorkersRequest
  ): IO[AwsError, zio.aws.deadline.model.SearchWorkersResponse.ReadOnly]
  def deleteStorageProfile(
      request: zio.aws.deadline.model.DeleteStorageProfileRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteStorageProfileResponse.ReadOnly]
  def getLicenseEndpoint(
      request: zio.aws.deadline.model.GetLicenseEndpointRequest
  ): IO[AwsError, zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly]
  def untagResource(
      request: zio.aws.deadline.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.deadline.model.UntagResourceResponse.ReadOnly]
  def listWorkers(
      request: zio.aws.deadline.model.ListWorkersRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.WorkerSummary.ReadOnly]
  def listWorkersPaginated(
      request: zio.aws.deadline.model.ListWorkersRequest
  ): IO[AwsError, zio.aws.deadline.model.ListWorkersResponse.ReadOnly]
  def getJob(
      request: zio.aws.deadline.model.GetJobRequest
  ): IO[AwsError, zio.aws.deadline.model.GetJobResponse.ReadOnly]
  def updateWorker(
      request: zio.aws.deadline.model.UpdateWorkerRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly]
  def deleteQueueEnvironment(
      request: zio.aws.deadline.model.DeleteQueueEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.DeleteQueueEnvironmentResponse.ReadOnly
  ]
  def listSessionActions(
      request: zio.aws.deadline.model.ListSessionActionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.SessionActionSummary.ReadOnly
  ]
  def listSessionActionsPaginated(
      request: zio.aws.deadline.model.ListSessionActionsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly]
  def listStepConsumers(
      request: zio.aws.deadline.model.ListStepConsumersRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.StepConsumer.ReadOnly]
  def listStepConsumersPaginated(
      request: zio.aws.deadline.model.ListStepConsumersRequest
  ): IO[AwsError, zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly]
  def listJobParameterDefinitions(
      request: zio.aws.deadline.model.ListJobParameterDefinitionsRequest
  ): ZStream[Any, AwsError, Document]
  def listJobParameterDefinitionsPaginated(
      request: zio.aws.deadline.model.ListJobParameterDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly
  ]
  def updateTask(
      request: zio.aws.deadline.model.UpdateTaskRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateTaskResponse.ReadOnly]
  def createQueue(
      request: zio.aws.deadline.model.CreateQueueRequest
  ): IO[AwsError, zio.aws.deadline.model.CreateQueueResponse.ReadOnly]
  def deleteQueueFleetAssociation(
      request: zio.aws.deadline.model.DeleteQueueFleetAssociationRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.DeleteQueueFleetAssociationResponse.ReadOnly
  ]
  def copyJobTemplate(
      request: zio.aws.deadline.model.CopyJobTemplateRequest
  ): IO[AwsError, zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly]
  def deleteLicenseEndpoint(
      request: zio.aws.deadline.model.DeleteLicenseEndpointRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteLicenseEndpointResponse.ReadOnly]
  def getTask(
      request: zio.aws.deadline.model.GetTaskRequest
  ): IO[AwsError, zio.aws.deadline.model.GetTaskResponse.ReadOnly]
  def updateJob(
      request: zio.aws.deadline.model.UpdateJobRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateJobResponse.ReadOnly]
  def assumeQueueRoleForWorker(
      request: zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly
  ]
  def getSessionAction(
      request: zio.aws.deadline.model.GetSessionActionRequest
  ): IO[AwsError, zio.aws.deadline.model.GetSessionActionResponse.ReadOnly]
  def deleteMeteredProduct(
      request: zio.aws.deadline.model.DeleteMeteredProductRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteMeteredProductResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.deadline.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.deadline.model.ListTagsForResourceResponse.ReadOnly]
  def listJobs(
      request: zio.aws.deadline.model.ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.JobSummary.ReadOnly]
  def listJobsPaginated(
      request: zio.aws.deadline.model.ListJobsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListJobsResponse.ReadOnly]
  def listMeteredProducts(
      request: zio.aws.deadline.model.ListMeteredProductsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.MeteredProductSummary.ReadOnly
  ]
  def listMeteredProductsPaginated(
      request: zio.aws.deadline.model.ListMeteredProductsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListMeteredProductsResponse.ReadOnly]
  def tagResource(
      request: zio.aws.deadline.model.TagResourceRequest
  ): IO[AwsError, zio.aws.deadline.model.TagResourceResponse.ReadOnly]
  def getWorker(
      request: zio.aws.deadline.model.GetWorkerRequest
  ): IO[AwsError, zio.aws.deadline.model.GetWorkerResponse.ReadOnly]
  def associateMemberToJob(
      request: zio.aws.deadline.model.AssociateMemberToJobRequest
  ): IO[AwsError, zio.aws.deadline.model.AssociateMemberToJobResponse.ReadOnly]
  def listSessions(
      request: zio.aws.deadline.model.ListSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.SessionSummary.ReadOnly]
  def listSessionsPaginated(
      request: zio.aws.deadline.model.ListSessionsRequest
  ): IO[AwsError, ReadOnly]
  def listQueueMembers(
      request: zio.aws.deadline.model.ListQueueMembersRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.QueueMember.ReadOnly]
  def listQueueMembersPaginated(
      request: zio.aws.deadline.model.ListQueueMembersRequest
  ): IO[AwsError, zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly]
  def listTasks(
      request: zio.aws.deadline.model.ListTasksRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.TaskSummary.ReadOnly]
  def listTasksPaginated(
      request: zio.aws.deadline.model.ListTasksRequest
  ): IO[AwsError, zio.aws.deadline.model.ListTasksResponse.ReadOnly]
  def getStorageProfile(
      request: zio.aws.deadline.model.GetStorageProfileRequest
  ): IO[AwsError, zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly]
  def updateFarm(
      request: zio.aws.deadline.model.UpdateFarmRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateFarmResponse.ReadOnly]
  def getSession(
      request: zio.aws.deadline.model.GetSessionRequest
  ): IO[AwsError, zio.aws.deadline.model.GetSessionResponse.ReadOnly]
  def disassociateMemberFromJob(
      request: zio.aws.deadline.model.DisassociateMemberFromJobRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromJobResponse.ReadOnly
  ]
  def listStepDependencies(
      request: zio.aws.deadline.model.ListStepDependenciesRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.StepDependency.ReadOnly]
  def listStepDependenciesPaginated(
      request: zio.aws.deadline.model.ListStepDependenciesRequest
  ): IO[AwsError, zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly]
  def updateSession(
      request: zio.aws.deadline.model.UpdateSessionRequest
  ): IO[AwsError, zio.aws.deadline.model.UpdateSessionResponse.ReadOnly]
  def getMonitor(
      request: zio.aws.deadline.model.GetMonitorRequest
  ): IO[AwsError, zio.aws.deadline.model.GetMonitorResponse.ReadOnly]
  def getQueue(
      request: zio.aws.deadline.model.GetQueueRequest
  ): IO[AwsError, zio.aws.deadline.model.GetQueueResponse.ReadOnly]
  def assumeFleetRoleForRead(
      request: zio.aws.deadline.model.AssumeFleetRoleForReadRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly
  ]
  def listBudgets(
      request: zio.aws.deadline.model.ListBudgetsRequest
  ): ZStream[Any, AwsError, zio.aws.deadline.model.BudgetSummary.ReadOnly]
  def listBudgetsPaginated(
      request: zio.aws.deadline.model.ListBudgetsRequest
  ): IO[AwsError, zio.aws.deadline.model.ListBudgetsResponse.ReadOnly]
  def getQueueFleetAssociation(
      request: zio.aws.deadline.model.GetQueueFleetAssociationRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly
  ]
  def deleteQueue(
      request: zio.aws.deadline.model.DeleteQueueRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteQueueResponse.ReadOnly]
  def listQueueFleetAssociations(
      request: zio.aws.deadline.model.ListQueueFleetAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly
  ]
  def listQueueFleetAssociationsPaginated(
      request: zio.aws.deadline.model.ListQueueFleetAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly
  ]
  def assumeQueueRoleForUser(
      request: zio.aws.deadline.model.AssumeQueueRoleForUserRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.AssumeQueueRoleForUserResponse.ReadOnly
  ]
  def batchGetJobEntity(
      request: zio.aws.deadline.model.BatchGetJobEntityRequest
  ): IO[AwsError, zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly]
  def associateMemberToFarm(
      request: zio.aws.deadline.model.AssociateMemberToFarmRequest
  ): IO[AwsError, zio.aws.deadline.model.AssociateMemberToFarmResponse.ReadOnly]
  def deleteFarm(
      request: zio.aws.deadline.model.DeleteFarmRequest
  ): IO[AwsError, zio.aws.deadline.model.DeleteFarmResponse.ReadOnly]
  def createQueueEnvironment(
      request: zio.aws.deadline.model.CreateQueueEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly
  ]
  def listAvailableMeteredProducts(
      request: zio.aws.deadline.model.ListAvailableMeteredProductsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.deadline.model.MeteredProductSummary.ReadOnly
  ]
  def listAvailableMeteredProductsPaginated(
      request: zio.aws.deadline.model.ListAvailableMeteredProductsRequest
  ): IO[
    AwsError,
    zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly
  ]
}
object Deadline {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Deadline] = customized(
    identity
  )
  def customized(
      customization: DeadlineAsyncClientBuilder => DeadlineAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Deadline] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DeadlineAsyncClientBuilder => DeadlineAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Deadline] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DeadlineAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[DeadlineAsyncClient, DeadlineAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[DeadlineAsyncClient, DeadlineAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DeadlineImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DeadlineImpl[R](
      override val api: DeadlineAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Deadline
      with AwsServiceBase[R] {
    override val serviceName: String = "Deadline"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DeadlineImpl[R1] = new DeadlineImpl(api, newAspect, r)
    def associateMemberToFleet(
        request: zio.aws.deadline.model.AssociateMemberToFleetRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssociateMemberToFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMemberToFleetRequest,
      AssociateMemberToFleetResponse
    ]("associateMemberToFleet", api.associateMemberToFleet)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssociateMemberToFleetResponse.wrap)
      .provideEnvironment(r)
    def listMonitors(
        request: zio.aws.deadline.model.ListMonitorsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.MonitorSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListMonitorsRequest,
        MonitorSummary,
        ListMonitorsPublisher
      ]("listMonitors", api.listMonitorsPaginator, _.monitors())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.MonitorSummary.wrap(item))
        .provideEnvironment(r)
    def listMonitorsPaginated(
        request: zio.aws.deadline.model.ListMonitorsRequest
    ): IO[AwsError, zio.aws.deadline.model.ListMonitorsResponse.ReadOnly] =
      asyncRequestResponse[ListMonitorsRequest, ListMonitorsResponse](
        "listMonitors",
        api.listMonitors
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListMonitorsResponse.wrap)
        .provideEnvironment(r)
    def updateQueue(
        request: zio.aws.deadline.model.UpdateQueueRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateQueueResponse.ReadOnly] =
      asyncRequestResponse[UpdateQueueRequest, UpdateQueueResponse](
        "updateQueue",
        api.updateQueue
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateQueueResponse.wrap)
        .provideEnvironment(r)
    def associateMemberToQueue(
        request: zio.aws.deadline.model.AssociateMemberToQueueRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssociateMemberToQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMemberToQueueRequest,
      AssociateMemberToQueueResponse
    ]("associateMemberToQueue", api.associateMemberToQueue)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssociateMemberToQueueResponse.wrap)
      .provideEnvironment(r)
    def deleteWorker(
        request: zio.aws.deadline.model.DeleteWorkerRequest
    ): IO[AwsError, zio.aws.deadline.model.DeleteWorkerResponse.ReadOnly] =
      asyncRequestResponse[DeleteWorkerRequest, DeleteWorkerResponse](
        "deleteWorker",
        api.deleteWorker
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.DeleteWorkerResponse.wrap)
        .provideEnvironment(r)
    def searchSteps(
        request: zio.aws.deadline.model.SearchStepsRequest
    ): IO[AwsError, zio.aws.deadline.model.SearchStepsResponse.ReadOnly] =
      asyncRequestResponse[SearchStepsRequest, SearchStepsResponse](
        "searchSteps",
        api.searchSteps
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.SearchStepsResponse.wrap)
        .provideEnvironment(r)
    def updateQueueEnvironment(
        request: zio.aws.deadline.model.UpdateQueueEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.UpdateQueueEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateQueueEnvironmentRequest,
      UpdateQueueEnvironmentResponse
    ]("updateQueueEnvironment", api.updateQueueEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.UpdateQueueEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def getBudget(
        request: zio.aws.deadline.model.GetBudgetRequest
    ): IO[AwsError, zio.aws.deadline.model.GetBudgetResponse.ReadOnly] =
      asyncRequestResponse[GetBudgetRequest, GetBudgetResponse](
        "getBudget",
        api.getBudget
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetBudgetResponse.wrap)
        .provideEnvironment(r)
    def getFarm(
        request: zio.aws.deadline.model.GetFarmRequest
    ): IO[AwsError, zio.aws.deadline.model.GetFarmResponse.ReadOnly] =
      asyncRequestResponse[GetFarmRequest, GetFarmResponse](
        "getFarm",
        api.getFarm
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetFarmResponse.wrap)
        .provideEnvironment(r)
    def startSessionsStatisticsAggregation(
        request: zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartSessionsStatisticsAggregationRequest,
      StartSessionsStatisticsAggregationResponse
    ](
      "startSessionsStatisticsAggregation",
      api.startSessionsStatisticsAggregation
    )(request.buildAwsValue())
      .map(
        zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.wrap
      )
      .provideEnvironment(r)
    def createLicenseEndpoint(
        request: zio.aws.deadline.model.CreateLicenseEndpointRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLicenseEndpointRequest,
      CreateLicenseEndpointResponse
    ]("createLicenseEndpoint", api.createLicenseEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.CreateLicenseEndpointResponse.wrap)
      .provideEnvironment(r)
    def updateMonitor(
        request: zio.aws.deadline.model.UpdateMonitorRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateMonitorResponse.ReadOnly] =
      asyncRequestResponse[UpdateMonitorRequest, UpdateMonitorResponse](
        "updateMonitor",
        api.updateMonitor
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateMonitorResponse.wrap)
        .provideEnvironment(r)
    def listFleetMembers(
        request: zio.aws.deadline.model.ListFleetMembersRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.FleetMember.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListFleetMembersRequest,
        FleetMember,
        ListFleetMembersPublisher
      ]("listFleetMembers", api.listFleetMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.FleetMember.wrap(item))
        .provideEnvironment(r)
    def listFleetMembersPaginated(
        request: zio.aws.deadline.model.ListFleetMembersRequest
    ): IO[AwsError, zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly] =
      asyncRequestResponse[ListFleetMembersRequest, ListFleetMembersResponse](
        "listFleetMembers",
        api.listFleetMembers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListFleetMembersResponse.wrap)
        .provideEnvironment(r)
    def getQueueEnvironment(
        request: zio.aws.deadline.model.GetQueueEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      GetQueueEnvironmentRequest,
      GetQueueEnvironmentResponse
    ]("getQueueEnvironment", api.getQueueEnvironment)(request.buildAwsValue())
      .map(zio.aws.deadline.model.GetQueueEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def putMeteredProduct(
        request: zio.aws.deadline.model.PutMeteredProductRequest
    ): IO[AwsError, zio.aws.deadline.model.PutMeteredProductResponse.ReadOnly] =
      asyncRequestResponse[PutMeteredProductRequest, PutMeteredProductResponse](
        "putMeteredProduct",
        api.putMeteredProduct
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.PutMeteredProductResponse.wrap)
        .provideEnvironment(r)
    def listStorageProfiles(
        request: zio.aws.deadline.model.ListStorageProfilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.StorageProfileSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListStorageProfilesRequest,
      StorageProfileSummary,
      ListStorageProfilesPublisher
    ](
      "listStorageProfiles",
      api.listStorageProfilesPaginator,
      _.storageProfiles()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.StorageProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listStorageProfilesPaginated(
        request: zio.aws.deadline.model.ListStorageProfilesRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListStorageProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListStorageProfilesRequest,
      ListStorageProfilesResponse
    ]("listStorageProfiles", api.listStorageProfiles)(request.buildAwsValue())
      .map(zio.aws.deadline.model.ListStorageProfilesResponse.wrap)
      .provideEnvironment(r)
    def createWorker(
        request: zio.aws.deadline.model.CreateWorkerRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateWorkerResponse.ReadOnly] =
      asyncRequestResponse[CreateWorkerRequest, CreateWorkerResponse](
        "createWorker",
        api.createWorker
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateWorkerResponse.wrap)
        .provideEnvironment(r)
    def updateWorkerSchedule(
        request: zio.aws.deadline.model.UpdateWorkerScheduleRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateWorkerScheduleRequest,
      UpdateWorkerScheduleResponse
    ]("updateWorkerSchedule", api.updateWorkerSchedule)(request.buildAwsValue())
      .map(zio.aws.deadline.model.UpdateWorkerScheduleResponse.wrap)
      .provideEnvironment(r)
    def listFarms(
        request: zio.aws.deadline.model.ListFarmsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.FarmSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListFarmsRequest,
        FarmSummary,
        ListFarmsPublisher
      ]("listFarms", api.listFarmsPaginator, _.farms())(request.buildAwsValue())
        .map(item => zio.aws.deadline.model.FarmSummary.wrap(item))
        .provideEnvironment(r)
    def listFarmsPaginated(
        request: zio.aws.deadline.model.ListFarmsRequest
    ): IO[AwsError, zio.aws.deadline.model.ListFarmsResponse.ReadOnly] =
      asyncRequestResponse[ListFarmsRequest, ListFarmsResponse](
        "listFarms",
        api.listFarms
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListFarmsResponse.wrap)
        .provideEnvironment(r)
    def createStorageProfile(
        request: zio.aws.deadline.model.CreateStorageProfileRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateStorageProfileRequest,
      CreateStorageProfileResponse
    ]("createStorageProfile", api.createStorageProfile)(request.buildAwsValue())
      .map(zio.aws.deadline.model.CreateStorageProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteBudget(
        request: zio.aws.deadline.model.DeleteBudgetRequest
    ): IO[AwsError, zio.aws.deadline.model.DeleteBudgetResponse.ReadOnly] =
      asyncRequestResponse[DeleteBudgetRequest, DeleteBudgetResponse](
        "deleteBudget",
        api.deleteBudget
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.DeleteBudgetResponse.wrap)
        .provideEnvironment(r)
    def createBudget(
        request: zio.aws.deadline.model.CreateBudgetRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateBudgetResponse.ReadOnly] =
      asyncRequestResponse[CreateBudgetRequest, CreateBudgetResponse](
        "createBudget",
        api.createBudget
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateBudgetResponse.wrap)
        .provideEnvironment(r)
    def disassociateMemberFromFarm(
        request: zio.aws.deadline.model.DisassociateMemberFromFarmRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DisassociateMemberFromFarmResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMemberFromFarmRequest,
      DisassociateMemberFromFarmResponse
    ]("disassociateMemberFromFarm", api.disassociateMemberFromFarm)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DisassociateMemberFromFarmResponse.wrap)
      .provideEnvironment(r)
    def assumeQueueRoleForRead(
        request: zio.aws.deadline.model.AssumeQueueRoleForReadRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly
    ] = asyncRequestResponse[
      AssumeQueueRoleForReadRequest,
      AssumeQueueRoleForReadResponse
    ]("assumeQueueRoleForRead", api.assumeQueueRoleForRead)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssumeQueueRoleForReadResponse.wrap)
      .provideEnvironment(r)
    def disassociateMemberFromQueue(
        request: zio.aws.deadline.model.DisassociateMemberFromQueueRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DisassociateMemberFromQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMemberFromQueueRequest,
      DisassociateMemberFromQueueResponse
    ]("disassociateMemberFromQueue", api.disassociateMemberFromQueue)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DisassociateMemberFromQueueResponse.wrap)
      .provideEnvironment(r)
    def getStep(
        request: zio.aws.deadline.model.GetStepRequest
    ): IO[AwsError, zio.aws.deadline.model.GetStepResponse.ReadOnly] =
      asyncRequestResponse[GetStepRequest, GetStepResponse](
        "getStep",
        api.getStep
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetStepResponse.wrap)
        .provideEnvironment(r)
    def listFleets(
        request: zio.aws.deadline.model.ListFleetsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.FleetSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListFleetsRequest,
        FleetSummary,
        ListFleetsPublisher
      ]("listFleets", api.listFleetsPaginator, _.fleets())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.FleetSummary.wrap(item))
        .provideEnvironment(r)
    def listFleetsPaginated(
        request: zio.aws.deadline.model.ListFleetsRequest
    ): IO[AwsError, zio.aws.deadline.model.ListFleetsResponse.ReadOnly] =
      asyncRequestResponse[ListFleetsRequest, ListFleetsResponse](
        "listFleets",
        api.listFleets
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListFleetsResponse.wrap)
        .provideEnvironment(r)
    def disassociateMemberFromFleet(
        request: zio.aws.deadline.model.DisassociateMemberFromFleetRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DisassociateMemberFromFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMemberFromFleetRequest,
      DisassociateMemberFromFleetResponse
    ]("disassociateMemberFromFleet", api.disassociateMemberFromFleet)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DisassociateMemberFromFleetResponse.wrap)
      .provideEnvironment(r)
    def listQueues(
        request: zio.aws.deadline.model.ListQueuesRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.QueueSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListQueuesRequest,
        QueueSummary,
        ListQueuesPublisher
      ]("listQueues", api.listQueuesPaginator, _.queues())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.QueueSummary.wrap(item))
        .provideEnvironment(r)
    def listQueuesPaginated(
        request: zio.aws.deadline.model.ListQueuesRequest
    ): IO[AwsError, zio.aws.deadline.model.ListQueuesResponse.ReadOnly] =
      asyncRequestResponse[ListQueuesRequest, ListQueuesResponse](
        "listQueues",
        api.listQueues
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListQueuesResponse.wrap)
        .provideEnvironment(r)
    def assumeFleetRoleForWorker(
        request: zio.aws.deadline.model.AssumeFleetRoleForWorkerRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssumeFleetRoleForWorkerResponse.ReadOnly
    ] = asyncRequestResponse[
      AssumeFleetRoleForWorkerRequest,
      AssumeFleetRoleForWorkerResponse
    ]("assumeFleetRoleForWorker", api.assumeFleetRoleForWorker)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssumeFleetRoleForWorkerResponse.wrap)
      .provideEnvironment(r)
    def listQueueEnvironments(
        request: zio.aws.deadline.model.ListQueueEnvironmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListQueueEnvironmentsRequest,
      QueueEnvironmentSummary,
      ListQueueEnvironmentsPublisher
    ](
      "listQueueEnvironments",
      api.listQueueEnvironmentsPaginator,
      _.environments()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.QueueEnvironmentSummary.wrap(item))
      .provideEnvironment(r)
    def listQueueEnvironmentsPaginated(
        request: zio.aws.deadline.model.ListQueueEnvironmentsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListQueueEnvironmentsRequest,
      ListQueueEnvironmentsResponse
    ]("listQueueEnvironments", api.listQueueEnvironments)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.ListQueueEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def updateQueueFleetAssociation(
        request: zio.aws.deadline.model.UpdateQueueFleetAssociationRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.UpdateQueueFleetAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateQueueFleetAssociationRequest,
      UpdateQueueFleetAssociationResponse
    ]("updateQueueFleetAssociation", api.updateQueueFleetAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.UpdateQueueFleetAssociationResponse.wrap)
      .provideEnvironment(r)
    def listLicenseEndpoints(
        request: zio.aws.deadline.model.ListLicenseEndpointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListLicenseEndpointsRequest,
      LicenseEndpointSummary,
      ListLicenseEndpointsPublisher
    ](
      "listLicenseEndpoints",
      api.listLicenseEndpointsPaginator,
      _.licenseEndpoints()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.LicenseEndpointSummary.wrap(item))
      .provideEnvironment(r)
    def listLicenseEndpointsPaginated(
        request: zio.aws.deadline.model.ListLicenseEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListLicenseEndpointsRequest,
      ListLicenseEndpointsResponse
    ]("listLicenseEndpoints", api.listLicenseEndpoints)(request.buildAwsValue())
      .map(zio.aws.deadline.model.ListLicenseEndpointsResponse.wrap)
      .provideEnvironment(r)
    def listStorageProfilesForQueue(
        request: zio.aws.deadline.model.ListStorageProfilesForQueueRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.StorageProfileSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListStorageProfilesForQueueRequest,
      StorageProfileSummary,
      ListStorageProfilesForQueuePublisher
    ](
      "listStorageProfilesForQueue",
      api.listStorageProfilesForQueuePaginator,
      _.storageProfiles()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.StorageProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listStorageProfilesForQueuePaginated(
        request: zio.aws.deadline.model.ListStorageProfilesForQueueRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      ListStorageProfilesForQueueRequest,
      ListStorageProfilesForQueueResponse
    ]("listStorageProfilesForQueue", api.listStorageProfilesForQueue)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.ListStorageProfilesForQueueResponse.wrap)
      .provideEnvironment(r)
    def listJobMembers(
        request: zio.aws.deadline.model.ListJobMembersRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.JobMember.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListJobMembersRequest,
        JobMember,
        ListJobMembersPublisher
      ]("listJobMembers", api.listJobMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.JobMember.wrap(item))
        .provideEnvironment(r)
    def listJobMembersPaginated(
        request: zio.aws.deadline.model.ListJobMembersRequest
    ): IO[AwsError, zio.aws.deadline.model.ListJobMembersResponse.ReadOnly] =
      asyncRequestResponse[ListJobMembersRequest, ListJobMembersResponse](
        "listJobMembers",
        api.listJobMembers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListJobMembersResponse.wrap)
        .provideEnvironment(r)
    def createJob(
        request: zio.aws.deadline.model.CreateJobRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateJobResponse.ReadOnly] =
      asyncRequestResponse[CreateJobRequest, CreateJobResponse](
        "createJob",
        api.createJob
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateJobResponse.wrap)
        .provideEnvironment(r)
    def deleteMonitor(
        request: zio.aws.deadline.model.DeleteMonitorRequest
    ): IO[AwsError, zio.aws.deadline.model.DeleteMonitorResponse.ReadOnly] =
      asyncRequestResponse[DeleteMonitorRequest, DeleteMonitorResponse](
        "deleteMonitor",
        api.deleteMonitor
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.DeleteMonitorResponse.wrap)
        .provideEnvironment(r)
    def updateBudget(
        request: zio.aws.deadline.model.UpdateBudgetRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateBudgetResponse.ReadOnly] =
      asyncRequestResponse[UpdateBudgetRequest, UpdateBudgetResponse](
        "updateBudget",
        api.updateBudget
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateBudgetResponse.wrap)
        .provideEnvironment(r)
    def getSessionsStatisticsAggregation(
        request: zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.Statistics.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetSessionsStatisticsAggregationRequest,
        Statistics,
        GetSessionsStatisticsAggregationPublisher
      ](
        "getSessionsStatisticsAggregation",
        api.getSessionsStatisticsAggregationPaginator,
        _.statistics()
      )(request.buildAwsValue())
        .map(item => zio.aws.deadline.model.Statistics.wrap(item))
        .provideEnvironment(r)
    def getSessionsStatisticsAggregationPaginated(
        request: zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSessionsStatisticsAggregationRequest,
      GetSessionsStatisticsAggregationResponse
    ]("getSessionsStatisticsAggregation", api.getSessionsStatisticsAggregation)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.wrap)
      .provideEnvironment(r)
    def createFarm(
        request: zio.aws.deadline.model.CreateFarmRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateFarmResponse.ReadOnly] =
      asyncRequestResponse[CreateFarmRequest, CreateFarmResponse](
        "createFarm",
        api.createFarm
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateFarmResponse.wrap)
        .provideEnvironment(r)
    def createQueueFleetAssociation(
        request: zio.aws.deadline.model.CreateQueueFleetAssociationRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.CreateQueueFleetAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateQueueFleetAssociationRequest,
      CreateQueueFleetAssociationResponse
    ]("createQueueFleetAssociation", api.createQueueFleetAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.CreateQueueFleetAssociationResponse.wrap)
      .provideEnvironment(r)
    def searchTasks(
        request: zio.aws.deadline.model.SearchTasksRequest
    ): IO[AwsError, zio.aws.deadline.model.SearchTasksResponse.ReadOnly] =
      asyncRequestResponse[SearchTasksRequest, SearchTasksResponse](
        "searchTasks",
        api.searchTasks
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.SearchTasksResponse.wrap)
        .provideEnvironment(r)
    def deleteFleet(
        request: zio.aws.deadline.model.DeleteFleetRequest
    ): IO[AwsError, zio.aws.deadline.model.DeleteFleetResponse.ReadOnly] =
      asyncRequestResponse[DeleteFleetRequest, DeleteFleetResponse](
        "deleteFleet",
        api.deleteFleet
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.DeleteFleetResponse.wrap)
        .provideEnvironment(r)
    def updateStorageProfile(
        request: zio.aws.deadline.model.UpdateStorageProfileRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.UpdateStorageProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateStorageProfileRequest,
      UpdateStorageProfileResponse
    ]("updateStorageProfile", api.updateStorageProfile)(request.buildAwsValue())
      .map(zio.aws.deadline.model.UpdateStorageProfileResponse.wrap)
      .provideEnvironment(r)
    def createMonitor(
        request: zio.aws.deadline.model.CreateMonitorRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateMonitorResponse.ReadOnly] =
      asyncRequestResponse[CreateMonitorRequest, CreateMonitorResponse](
        "createMonitor",
        api.createMonitor
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateMonitorResponse.wrap)
        .provideEnvironment(r)
    def listFarmMembers(
        request: zio.aws.deadline.model.ListFarmMembersRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.FarmMember.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListFarmMembersRequest,
        FarmMember,
        ListFarmMembersPublisher
      ]("listFarmMembers", api.listFarmMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.FarmMember.wrap(item))
        .provideEnvironment(r)
    def listFarmMembersPaginated(
        request: zio.aws.deadline.model.ListFarmMembersRequest
    ): IO[AwsError, zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly] =
      asyncRequestResponse[ListFarmMembersRequest, ListFarmMembersResponse](
        "listFarmMembers",
        api.listFarmMembers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListFarmMembersResponse.wrap)
        .provideEnvironment(r)
    def getStorageProfileForQueue(
        request: zio.aws.deadline.model.GetStorageProfileForQueueRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly
    ] = asyncRequestResponse[
      GetStorageProfileForQueueRequest,
      GetStorageProfileForQueueResponse
    ]("getStorageProfileForQueue", api.getStorageProfileForQueue)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.GetStorageProfileForQueueResponse.wrap)
      .provideEnvironment(r)
    def searchJobs(
        request: zio.aws.deadline.model.SearchJobsRequest
    ): IO[AwsError, zio.aws.deadline.model.SearchJobsResponse.ReadOnly] =
      asyncRequestResponse[SearchJobsRequest, SearchJobsResponse](
        "searchJobs",
        api.searchJobs
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.SearchJobsResponse.wrap)
        .provideEnvironment(r)
    def updateFleet(
        request: zio.aws.deadline.model.UpdateFleetRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateFleetResponse.ReadOnly] =
      asyncRequestResponse[UpdateFleetRequest, UpdateFleetResponse](
        "updateFleet",
        api.updateFleet
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateFleetResponse.wrap)
        .provideEnvironment(r)
    def getFleet(
        request: zio.aws.deadline.model.GetFleetRequest
    ): IO[AwsError, zio.aws.deadline.model.GetFleetResponse.ReadOnly] =
      asyncRequestResponse[GetFleetRequest, GetFleetResponse](
        "getFleet",
        api.getFleet
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetFleetResponse.wrap)
        .provideEnvironment(r)
    def listSessionsForWorker(
        request: zio.aws.deadline.model.ListSessionsForWorkerRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.WorkerSessionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSessionsForWorkerRequest,
      WorkerSessionSummary,
      ListSessionsForWorkerPublisher
    ](
      "listSessionsForWorker",
      api.listSessionsForWorkerPaginator,
      _.sessions()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.WorkerSessionSummary.wrap(item))
      .provideEnvironment(r)
    def listSessionsForWorkerPaginated(
        request: zio.aws.deadline.model.ListSessionsForWorkerRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSessionsForWorkerRequest,
      ListSessionsForWorkerResponse
    ]("listSessionsForWorker", api.listSessionsForWorker)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.ListSessionsForWorkerResponse.wrap)
      .provideEnvironment(r)
    def updateStep(
        request: zio.aws.deadline.model.UpdateStepRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateStepResponse.ReadOnly] =
      asyncRequestResponse[UpdateStepRequest, UpdateStepResponse](
        "updateStep",
        api.updateStep
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateStepResponse.wrap)
        .provideEnvironment(r)
    def listSteps(
        request: zio.aws.deadline.model.ListStepsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.StepSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListStepsRequest,
        StepSummary,
        ListStepsPublisher
      ]("listSteps", api.listStepsPaginator, _.steps())(request.buildAwsValue())
        .map(item => zio.aws.deadline.model.StepSummary.wrap(item))
        .provideEnvironment(r)
    def listStepsPaginated(
        request: zio.aws.deadline.model.ListStepsRequest
    ): IO[AwsError, zio.aws.deadline.model.ListStepsResponse.ReadOnly] =
      asyncRequestResponse[ListStepsRequest, ListStepsResponse](
        "listSteps",
        api.listSteps
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListStepsResponse.wrap)
        .provideEnvironment(r)
    def createFleet(
        request: zio.aws.deadline.model.CreateFleetRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateFleetResponse.ReadOnly] =
      asyncRequestResponse[CreateFleetRequest, CreateFleetResponse](
        "createFleet",
        api.createFleet
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateFleetResponse.wrap)
        .provideEnvironment(r)
    def searchWorkers(
        request: zio.aws.deadline.model.SearchWorkersRequest
    ): IO[AwsError, zio.aws.deadline.model.SearchWorkersResponse.ReadOnly] =
      asyncRequestResponse[SearchWorkersRequest, SearchWorkersResponse](
        "searchWorkers",
        api.searchWorkers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.SearchWorkersResponse.wrap)
        .provideEnvironment(r)
    def deleteStorageProfile(
        request: zio.aws.deadline.model.DeleteStorageProfileRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DeleteStorageProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteStorageProfileRequest,
      DeleteStorageProfileResponse
    ]("deleteStorageProfile", api.deleteStorageProfile)(request.buildAwsValue())
      .map(zio.aws.deadline.model.DeleteStorageProfileResponse.wrap)
      .provideEnvironment(r)
    def getLicenseEndpoint(
        request: zio.aws.deadline.model.GetLicenseEndpointRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      GetLicenseEndpointRequest,
      GetLicenseEndpointResponse
    ]("getLicenseEndpoint", api.getLicenseEndpoint)(request.buildAwsValue())
      .map(zio.aws.deadline.model.GetLicenseEndpointResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.deadline.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.deadline.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listWorkers(
        request: zio.aws.deadline.model.ListWorkersRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.WorkerSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListWorkersRequest,
        WorkerSummary,
        ListWorkersPublisher
      ]("listWorkers", api.listWorkersPaginator, _.workers())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.WorkerSummary.wrap(item))
        .provideEnvironment(r)
    def listWorkersPaginated(
        request: zio.aws.deadline.model.ListWorkersRequest
    ): IO[AwsError, zio.aws.deadline.model.ListWorkersResponse.ReadOnly] =
      asyncRequestResponse[ListWorkersRequest, ListWorkersResponse](
        "listWorkers",
        api.listWorkers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListWorkersResponse.wrap)
        .provideEnvironment(r)
    def getJob(
        request: zio.aws.deadline.model.GetJobRequest
    ): IO[AwsError, zio.aws.deadline.model.GetJobResponse.ReadOnly] =
      asyncRequestResponse[GetJobRequest, GetJobResponse]("getJob", api.getJob)(
        request.buildAwsValue()
      ).map(zio.aws.deadline.model.GetJobResponse.wrap).provideEnvironment(r)
    def updateWorker(
        request: zio.aws.deadline.model.UpdateWorkerRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly] =
      asyncRequestResponse[UpdateWorkerRequest, UpdateWorkerResponse](
        "updateWorker",
        api.updateWorker
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateWorkerResponse.wrap)
        .provideEnvironment(r)
    def deleteQueueEnvironment(
        request: zio.aws.deadline.model.DeleteQueueEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DeleteQueueEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteQueueEnvironmentRequest,
      DeleteQueueEnvironmentResponse
    ]("deleteQueueEnvironment", api.deleteQueueEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DeleteQueueEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listSessionActions(
        request: zio.aws.deadline.model.ListSessionActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.SessionActionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListSessionActionsRequest,
      SessionActionSummary,
      ListSessionActionsPublisher
    ](
      "listSessionActions",
      api.listSessionActionsPaginator,
      _.sessionActions()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.SessionActionSummary.wrap(item))
      .provideEnvironment(r)
    def listSessionActionsPaginated(
        request: zio.aws.deadline.model.ListSessionActionsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSessionActionsRequest,
      ListSessionActionsResponse
    ]("listSessionActions", api.listSessionActions)(request.buildAwsValue())
      .map(zio.aws.deadline.model.ListSessionActionsResponse.wrap)
      .provideEnvironment(r)
    def listStepConsumers(
        request: zio.aws.deadline.model.ListStepConsumersRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.StepConsumer.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListStepConsumersRequest,
        StepConsumer,
        ListStepConsumersPublisher
      ]("listStepConsumers", api.listStepConsumersPaginator, _.consumers())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.StepConsumer.wrap(item))
        .provideEnvironment(r)
    def listStepConsumersPaginated(
        request: zio.aws.deadline.model.ListStepConsumersRequest
    ): IO[AwsError, zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly] =
      asyncRequestResponse[ListStepConsumersRequest, ListStepConsumersResponse](
        "listStepConsumers",
        api.listStepConsumers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListStepConsumersResponse.wrap)
        .provideEnvironment(r)
    def listJobParameterDefinitions(
        request: zio.aws.deadline.model.ListJobParameterDefinitionsRequest
    ): ZStream[Any, AwsError, Document] = asyncJavaPaginatedRequest[
      ListJobParameterDefinitionsRequest,
      Document,
      ListJobParameterDefinitionsPublisher
    ](
      "listJobParameterDefinitions",
      api.listJobParameterDefinitionsPaginator,
      _.jobParameterDefinitions()
    )(request.buildAwsValue()).map(item => item).provideEnvironment(r)
    def listJobParameterDefinitionsPaginated(
        request: zio.aws.deadline.model.ListJobParameterDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListJobParameterDefinitionsRequest,
      ListJobParameterDefinitionsResponse
    ]("listJobParameterDefinitions", api.listJobParameterDefinitions)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.ListJobParameterDefinitionsResponse.wrap)
      .provideEnvironment(r)
    def updateTask(
        request: zio.aws.deadline.model.UpdateTaskRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateTaskResponse.ReadOnly] =
      asyncRequestResponse[UpdateTaskRequest, UpdateTaskResponse](
        "updateTask",
        api.updateTask
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateTaskResponse.wrap)
        .provideEnvironment(r)
    def createQueue(
        request: zio.aws.deadline.model.CreateQueueRequest
    ): IO[AwsError, zio.aws.deadline.model.CreateQueueResponse.ReadOnly] =
      asyncRequestResponse[CreateQueueRequest, CreateQueueResponse](
        "createQueue",
        api.createQueue
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CreateQueueResponse.wrap)
        .provideEnvironment(r)
    def deleteQueueFleetAssociation(
        request: zio.aws.deadline.model.DeleteQueueFleetAssociationRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DeleteQueueFleetAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteQueueFleetAssociationRequest,
      DeleteQueueFleetAssociationResponse
    ]("deleteQueueFleetAssociation", api.deleteQueueFleetAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DeleteQueueFleetAssociationResponse.wrap)
      .provideEnvironment(r)
    def copyJobTemplate(
        request: zio.aws.deadline.model.CopyJobTemplateRequest
    ): IO[AwsError, zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly] =
      asyncRequestResponse[CopyJobTemplateRequest, CopyJobTemplateResponse](
        "copyJobTemplate",
        api.copyJobTemplate
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.CopyJobTemplateResponse.wrap)
        .provideEnvironment(r)
    def deleteLicenseEndpoint(
        request: zio.aws.deadline.model.DeleteLicenseEndpointRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DeleteLicenseEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteLicenseEndpointRequest,
      DeleteLicenseEndpointResponse
    ]("deleteLicenseEndpoint", api.deleteLicenseEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DeleteLicenseEndpointResponse.wrap)
      .provideEnvironment(r)
    def getTask(
        request: zio.aws.deadline.model.GetTaskRequest
    ): IO[AwsError, zio.aws.deadline.model.GetTaskResponse.ReadOnly] =
      asyncRequestResponse[GetTaskRequest, GetTaskResponse](
        "getTask",
        api.getTask
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetTaskResponse.wrap)
        .provideEnvironment(r)
    def updateJob(
        request: zio.aws.deadline.model.UpdateJobRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateJobResponse.ReadOnly] =
      asyncRequestResponse[UpdateJobRequest, UpdateJobResponse](
        "updateJob",
        api.updateJob
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateJobResponse.wrap)
        .provideEnvironment(r)
    def assumeQueueRoleForWorker(
        request: zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly
    ] = asyncRequestResponse[
      AssumeQueueRoleForWorkerRequest,
      AssumeQueueRoleForWorkerResponse
    ]("assumeQueueRoleForWorker", api.assumeQueueRoleForWorker)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.wrap)
      .provideEnvironment(r)
    def getSessionAction(
        request: zio.aws.deadline.model.GetSessionActionRequest
    ): IO[AwsError, zio.aws.deadline.model.GetSessionActionResponse.ReadOnly] =
      asyncRequestResponse[GetSessionActionRequest, GetSessionActionResponse](
        "getSessionAction",
        api.getSessionAction
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetSessionActionResponse.wrap)
        .provideEnvironment(r)
    def deleteMeteredProduct(
        request: zio.aws.deadline.model.DeleteMeteredProductRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DeleteMeteredProductResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMeteredProductRequest,
      DeleteMeteredProductResponse
    ]("deleteMeteredProduct", api.deleteMeteredProduct)(request.buildAwsValue())
      .map(zio.aws.deadline.model.DeleteMeteredProductResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.deadline.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.deadline.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listJobs(
        request: zio.aws.deadline.model.ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.JobSummary.ReadOnly] =
      asyncJavaPaginatedRequest[ListJobsRequest, JobSummary, ListJobsPublisher](
        "listJobs",
        api.listJobsPaginator,
        _.jobs()
      )(request.buildAwsValue())
        .map(item => zio.aws.deadline.model.JobSummary.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: zio.aws.deadline.model.ListJobsRequest
    ): IO[AwsError, zio.aws.deadline.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[ListJobsRequest, ListJobsResponse](
        "listJobs",
        api.listJobs
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def listMeteredProducts(
        request: zio.aws.deadline.model.ListMeteredProductsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.MeteredProductSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListMeteredProductsRequest,
      MeteredProductSummary,
      ListMeteredProductsPublisher
    ](
      "listMeteredProducts",
      api.listMeteredProductsPaginator,
      _.meteredProducts()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.MeteredProductSummary.wrap(item))
      .provideEnvironment(r)
    def listMeteredProductsPaginated(
        request: zio.aws.deadline.model.ListMeteredProductsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListMeteredProductsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMeteredProductsRequest,
      ListMeteredProductsResponse
    ]("listMeteredProducts", api.listMeteredProducts)(request.buildAwsValue())
      .map(zio.aws.deadline.model.ListMeteredProductsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.deadline.model.TagResourceRequest
    ): IO[AwsError, zio.aws.deadline.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getWorker(
        request: zio.aws.deadline.model.GetWorkerRequest
    ): IO[AwsError, zio.aws.deadline.model.GetWorkerResponse.ReadOnly] =
      asyncRequestResponse[GetWorkerRequest, GetWorkerResponse](
        "getWorker",
        api.getWorker
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetWorkerResponse.wrap)
        .provideEnvironment(r)
    def associateMemberToJob(
        request: zio.aws.deadline.model.AssociateMemberToJobRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssociateMemberToJobResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMemberToJobRequest,
      AssociateMemberToJobResponse
    ]("associateMemberToJob", api.associateMemberToJob)(request.buildAwsValue())
      .map(zio.aws.deadline.model.AssociateMemberToJobResponse.wrap)
      .provideEnvironment(r)
    def listSessions(
        request: zio.aws.deadline.model.ListSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.SessionSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListSessionsRequest,
        SessionSummary,
        ListSessionsPublisher
      ]("listSessions", api.listSessionsPaginator, _.sessions())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.SessionSummary.wrap(item))
        .provideEnvironment(r)
    def listSessionsPaginated(
        request: zio.aws.deadline.model.ListSessionsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListSessionsRequest, ListSessionsResponse](
        "listSessions",
        api.listSessions
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListSessionsResponse.wrap)
        .provideEnvironment(r)
    def listQueueMembers(
        request: zio.aws.deadline.model.ListQueueMembersRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.QueueMember.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListQueueMembersRequest,
        QueueMember,
        ListQueueMembersPublisher
      ]("listQueueMembers", api.listQueueMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.QueueMember.wrap(item))
        .provideEnvironment(r)
    def listQueueMembersPaginated(
        request: zio.aws.deadline.model.ListQueueMembersRequest
    ): IO[AwsError, zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly] =
      asyncRequestResponse[ListQueueMembersRequest, ListQueueMembersResponse](
        "listQueueMembers",
        api.listQueueMembers
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListQueueMembersResponse.wrap)
        .provideEnvironment(r)
    def listTasks(
        request: zio.aws.deadline.model.ListTasksRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.TaskSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTasksRequest,
        TaskSummary,
        ListTasksPublisher
      ]("listTasks", api.listTasksPaginator, _.tasks())(request.buildAwsValue())
        .map(item => zio.aws.deadline.model.TaskSummary.wrap(item))
        .provideEnvironment(r)
    def listTasksPaginated(
        request: zio.aws.deadline.model.ListTasksRequest
    ): IO[AwsError, zio.aws.deadline.model.ListTasksResponse.ReadOnly] =
      asyncRequestResponse[ListTasksRequest, ListTasksResponse](
        "listTasks",
        api.listTasks
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListTasksResponse.wrap)
        .provideEnvironment(r)
    def getStorageProfile(
        request: zio.aws.deadline.model.GetStorageProfileRequest
    ): IO[AwsError, zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly] =
      asyncRequestResponse[GetStorageProfileRequest, GetStorageProfileResponse](
        "getStorageProfile",
        api.getStorageProfile
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetStorageProfileResponse.wrap)
        .provideEnvironment(r)
    def updateFarm(
        request: zio.aws.deadline.model.UpdateFarmRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateFarmResponse.ReadOnly] =
      asyncRequestResponse[UpdateFarmRequest, UpdateFarmResponse](
        "updateFarm",
        api.updateFarm
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateFarmResponse.wrap)
        .provideEnvironment(r)
    def getSession(
        request: zio.aws.deadline.model.GetSessionRequest
    ): IO[AwsError, zio.aws.deadline.model.GetSessionResponse.ReadOnly] =
      asyncRequestResponse[GetSessionRequest, GetSessionResponse](
        "getSession",
        api.getSession
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetSessionResponse.wrap)
        .provideEnvironment(r)
    def disassociateMemberFromJob(
        request: zio.aws.deadline.model.DisassociateMemberFromJobRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.DisassociateMemberFromJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMemberFromJobRequest,
      DisassociateMemberFromJobResponse
    ]("disassociateMemberFromJob", api.disassociateMemberFromJob)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.DisassociateMemberFromJobResponse.wrap)
      .provideEnvironment(r)
    def listStepDependencies(
        request: zio.aws.deadline.model.ListStepDependenciesRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.StepDependency.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListStepDependenciesRequest,
        StepDependency,
        ListStepDependenciesPublisher
      ](
        "listStepDependencies",
        api.listStepDependenciesPaginator,
        _.dependencies()
      )(request.buildAwsValue())
        .map(item => zio.aws.deadline.model.StepDependency.wrap(item))
        .provideEnvironment(r)
    def listStepDependenciesPaginated(
        request: zio.aws.deadline.model.ListStepDependenciesRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListStepDependenciesRequest,
      ListStepDependenciesResponse
    ]("listStepDependencies", api.listStepDependencies)(request.buildAwsValue())
      .map(zio.aws.deadline.model.ListStepDependenciesResponse.wrap)
      .provideEnvironment(r)
    def updateSession(
        request: zio.aws.deadline.model.UpdateSessionRequest
    ): IO[AwsError, zio.aws.deadline.model.UpdateSessionResponse.ReadOnly] =
      asyncRequestResponse[UpdateSessionRequest, UpdateSessionResponse](
        "updateSession",
        api.updateSession
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.UpdateSessionResponse.wrap)
        .provideEnvironment(r)
    def getMonitor(
        request: zio.aws.deadline.model.GetMonitorRequest
    ): IO[AwsError, zio.aws.deadline.model.GetMonitorResponse.ReadOnly] =
      asyncRequestResponse[GetMonitorRequest, GetMonitorResponse](
        "getMonitor",
        api.getMonitor
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetMonitorResponse.wrap)
        .provideEnvironment(r)
    def getQueue(
        request: zio.aws.deadline.model.GetQueueRequest
    ): IO[AwsError, zio.aws.deadline.model.GetQueueResponse.ReadOnly] =
      asyncRequestResponse[GetQueueRequest, GetQueueResponse](
        "getQueue",
        api.getQueue
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.GetQueueResponse.wrap)
        .provideEnvironment(r)
    def assumeFleetRoleForRead(
        request: zio.aws.deadline.model.AssumeFleetRoleForReadRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly
    ] = asyncRequestResponse[
      AssumeFleetRoleForReadRequest,
      AssumeFleetRoleForReadResponse
    ]("assumeFleetRoleForRead", api.assumeFleetRoleForRead)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssumeFleetRoleForReadResponse.wrap)
      .provideEnvironment(r)
    def listBudgets(
        request: zio.aws.deadline.model.ListBudgetsRequest
    ): ZStream[Any, AwsError, zio.aws.deadline.model.BudgetSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListBudgetsRequest,
        BudgetSummary,
        ListBudgetsPublisher
      ]("listBudgets", api.listBudgetsPaginator, _.budgets())(
        request.buildAwsValue()
      ).map(item => zio.aws.deadline.model.BudgetSummary.wrap(item))
        .provideEnvironment(r)
    def listBudgetsPaginated(
        request: zio.aws.deadline.model.ListBudgetsRequest
    ): IO[AwsError, zio.aws.deadline.model.ListBudgetsResponse.ReadOnly] =
      asyncRequestResponse[ListBudgetsRequest, ListBudgetsResponse](
        "listBudgets",
        api.listBudgets
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.ListBudgetsResponse.wrap)
        .provideEnvironment(r)
    def getQueueFleetAssociation(
        request: zio.aws.deadline.model.GetQueueFleetAssociationRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetQueueFleetAssociationRequest,
      GetQueueFleetAssociationResponse
    ]("getQueueFleetAssociation", api.getQueueFleetAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.GetQueueFleetAssociationResponse.wrap)
      .provideEnvironment(r)
    def deleteQueue(
        request: zio.aws.deadline.model.DeleteQueueRequest
    ): IO[AwsError, zio.aws.deadline.model.DeleteQueueResponse.ReadOnly] =
      asyncRequestResponse[DeleteQueueRequest, DeleteQueueResponse](
        "deleteQueue",
        api.deleteQueue
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.DeleteQueueResponse.wrap)
        .provideEnvironment(r)
    def listQueueFleetAssociations(
        request: zio.aws.deadline.model.ListQueueFleetAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListQueueFleetAssociationsRequest,
      QueueFleetAssociationSummary,
      ListQueueFleetAssociationsPublisher
    ](
      "listQueueFleetAssociations",
      api.listQueueFleetAssociationsPaginator,
      _.queueFleetAssociations()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.deadline.model.QueueFleetAssociationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listQueueFleetAssociationsPaginated(
        request: zio.aws.deadline.model.ListQueueFleetAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListQueueFleetAssociationsRequest,
      ListQueueFleetAssociationsResponse
    ]("listQueueFleetAssociations", api.listQueueFleetAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.ListQueueFleetAssociationsResponse.wrap)
      .provideEnvironment(r)
    def assumeQueueRoleForUser(
        request: zio.aws.deadline.model.AssumeQueueRoleForUserRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssumeQueueRoleForUserResponse.ReadOnly
    ] = asyncRequestResponse[
      AssumeQueueRoleForUserRequest,
      AssumeQueueRoleForUserResponse
    ]("assumeQueueRoleForUser", api.assumeQueueRoleForUser)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssumeQueueRoleForUserResponse.wrap)
      .provideEnvironment(r)
    def batchGetJobEntity(
        request: zio.aws.deadline.model.BatchGetJobEntityRequest
    ): IO[AwsError, zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly] =
      asyncRequestResponse[BatchGetJobEntityRequest, BatchGetJobEntityResponse](
        "batchGetJobEntity",
        api.batchGetJobEntity
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.BatchGetJobEntityResponse.wrap)
        .provideEnvironment(r)
    def associateMemberToFarm(
        request: zio.aws.deadline.model.AssociateMemberToFarmRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.AssociateMemberToFarmResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMemberToFarmRequest,
      AssociateMemberToFarmResponse
    ]("associateMemberToFarm", api.associateMemberToFarm)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.AssociateMemberToFarmResponse.wrap)
      .provideEnvironment(r)
    def deleteFarm(
        request: zio.aws.deadline.model.DeleteFarmRequest
    ): IO[AwsError, zio.aws.deadline.model.DeleteFarmResponse.ReadOnly] =
      asyncRequestResponse[DeleteFarmRequest, DeleteFarmResponse](
        "deleteFarm",
        api.deleteFarm
      )(request.buildAwsValue())
        .map(zio.aws.deadline.model.DeleteFarmResponse.wrap)
        .provideEnvironment(r)
    def createQueueEnvironment(
        request: zio.aws.deadline.model.CreateQueueEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateQueueEnvironmentRequest,
      CreateQueueEnvironmentResponse
    ]("createQueueEnvironment", api.createQueueEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.CreateQueueEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listAvailableMeteredProducts(
        request: zio.aws.deadline.model.ListAvailableMeteredProductsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.deadline.model.MeteredProductSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListAvailableMeteredProductsRequest,
      MeteredProductSummary,
      ListAvailableMeteredProductsPublisher
    ](
      "listAvailableMeteredProducts",
      api.listAvailableMeteredProductsPaginator,
      _.meteredProducts()
    )(request.buildAwsValue())
      .map(item => zio.aws.deadline.model.MeteredProductSummary.wrap(item))
      .provideEnvironment(r)
    def listAvailableMeteredProductsPaginated(
        request: zio.aws.deadline.model.ListAvailableMeteredProductsRequest
    ): IO[
      AwsError,
      zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAvailableMeteredProductsRequest,
      ListAvailableMeteredProductsResponse
    ]("listAvailableMeteredProducts", api.listAvailableMeteredProducts)(
      request.buildAwsValue()
    ).map(zio.aws.deadline.model.ListAvailableMeteredProductsResponse.wrap)
      .provideEnvironment(r)
  }
  def associateMemberToFleet(
      request: zio.aws.deadline.model.AssociateMemberToFleetRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssociateMemberToFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMemberToFleet(request))
  def listMonitors(
      request: zio.aws.deadline.model.ListMonitorsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.MonitorSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMonitors(request))
  def listMonitorsPaginated(
      request: zio.aws.deadline.model.ListMonitorsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListMonitorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMonitorsPaginated(request))
  def updateQueue(request: zio.aws.deadline.model.UpdateQueueRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateQueue(request))
  def associateMemberToQueue(
      request: zio.aws.deadline.model.AssociateMemberToQueueRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssociateMemberToQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMemberToQueue(request))
  def deleteWorker(request: zio.aws.deadline.model.DeleteWorkerRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorker(request))
  def searchSteps(request: zio.aws.deadline.model.SearchStepsRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.SearchStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSteps(request))
  def updateQueueEnvironment(
      request: zio.aws.deadline.model.UpdateQueueEnvironmentRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateQueueEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateQueueEnvironment(request))
  def getBudget(request: zio.aws.deadline.model.GetBudgetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetBudgetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBudget(request))
  def getFarm(request: zio.aws.deadline.model.GetFarmRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetFarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFarm(request))
  def startSessionsStatisticsAggregation(
      request: zio.aws.deadline.model.StartSessionsStatisticsAggregationRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSessionsStatisticsAggregation(request))
  def createLicenseEndpoint(
      request: zio.aws.deadline.model.CreateLicenseEndpointRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLicenseEndpoint(request))
  def updateMonitor(request: zio.aws.deadline.model.UpdateMonitorRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMonitor(request))
  def listFleetMembers(
      request: zio.aws.deadline.model.ListFleetMembersRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.FleetMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listFleetMembers(request))
  def listFleetMembersPaginated(
      request: zio.aws.deadline.model.ListFleetMembersRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFleetMembersPaginated(request))
  def getQueueEnvironment(
      request: zio.aws.deadline.model.GetQueueEnvironmentRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueueEnvironment(request))
  def putMeteredProduct(
      request: zio.aws.deadline.model.PutMeteredProductRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.PutMeteredProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMeteredProduct(request))
  def listStorageProfiles(
      request: zio.aws.deadline.model.ListStorageProfilesRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.StorageProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStorageProfiles(request))
  def listStorageProfilesPaginated(
      request: zio.aws.deadline.model.ListStorageProfilesRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListStorageProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStorageProfilesPaginated(request))
  def createWorker(request: zio.aws.deadline.model.CreateWorkerRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorker(request))
  def updateWorkerSchedule(
      request: zio.aws.deadline.model.UpdateWorkerScheduleRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkerSchedule(request))
  def listFarms(request: zio.aws.deadline.model.ListFarmsRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.FarmSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFarms(request))
  def listFarmsPaginated(request: zio.aws.deadline.model.ListFarmsRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListFarmsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFarmsPaginated(request))
  def createStorageProfile(
      request: zio.aws.deadline.model.CreateStorageProfileRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStorageProfile(request))
  def deleteBudget(request: zio.aws.deadline.model.DeleteBudgetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteBudgetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBudget(request))
  def createBudget(request: zio.aws.deadline.model.CreateBudgetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateBudgetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBudget(request))
  def disassociateMemberFromFarm(
      request: zio.aws.deadline.model.DisassociateMemberFromFarmRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromFarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMemberFromFarm(request))
  def assumeQueueRoleForRead(
      request: zio.aws.deadline.model.AssumeQueueRoleForReadRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeQueueRoleForRead(request))
  def disassociateMemberFromQueue(
      request: zio.aws.deadline.model.DisassociateMemberFromQueueRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMemberFromQueue(request))
  def getStep(request: zio.aws.deadline.model.GetStepRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStep(request))
  def listFleets(request: zio.aws.deadline.model.ListFleetsRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.FleetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFleets(request))
  def listFleetsPaginated(
      request: zio.aws.deadline.model.ListFleetsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFleetsPaginated(request))
  def disassociateMemberFromFleet(
      request: zio.aws.deadline.model.DisassociateMemberFromFleetRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMemberFromFleet(request))
  def listQueues(request: zio.aws.deadline.model.ListQueuesRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.QueueSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueues(request))
  def listQueuesPaginated(
      request: zio.aws.deadline.model.ListQueuesRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueuesPaginated(request))
  def assumeFleetRoleForWorker(
      request: zio.aws.deadline.model.AssumeFleetRoleForWorkerRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssumeFleetRoleForWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeFleetRoleForWorker(request))
  def listQueueEnvironments(
      request: zio.aws.deadline.model.ListQueueEnvironmentsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueueEnvironments(request))
  def listQueueEnvironmentsPaginated(
      request: zio.aws.deadline.model.ListQueueEnvironmentsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueueEnvironmentsPaginated(request))
  def updateQueueFleetAssociation(
      request: zio.aws.deadline.model.UpdateQueueFleetAssociationRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateQueueFleetAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateQueueFleetAssociation(request))
  def listLicenseEndpoints(
      request: zio.aws.deadline.model.ListLicenseEndpointsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listLicenseEndpoints(request))
  def listLicenseEndpointsPaginated(
      request: zio.aws.deadline.model.ListLicenseEndpointsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLicenseEndpointsPaginated(request))
  def listStorageProfilesForQueue(
      request: zio.aws.deadline.model.ListStorageProfilesForQueueRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.StorageProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStorageProfilesForQueue(request))
  def listStorageProfilesForQueuePaginated(
      request: zio.aws.deadline.model.ListStorageProfilesForQueueRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStorageProfilesForQueuePaginated(request))
  def listJobMembers(
      request: zio.aws.deadline.model.ListJobMembersRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.JobMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobMembers(request))
  def listJobMembersPaginated(
      request: zio.aws.deadline.model.ListJobMembersRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListJobMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobMembersPaginated(request))
  def createJob(request: zio.aws.deadline.model.CreateJobRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createJob(request))
  def deleteMonitor(request: zio.aws.deadline.model.DeleteMonitorRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMonitor(request))
  def updateBudget(request: zio.aws.deadline.model.UpdateBudgetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateBudgetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBudget(request))
  def getSessionsStatisticsAggregation(
      request: zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.Statistics.ReadOnly
  ] = ZStream.serviceWithStream(_.getSessionsStatisticsAggregation(request))
  def getSessionsStatisticsAggregationPaginated(
      request: zio.aws.deadline.model.GetSessionsStatisticsAggregationRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSessionsStatisticsAggregationPaginated(request))
  def createFarm(request: zio.aws.deadline.model.CreateFarmRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateFarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFarm(request))
  def createQueueFleetAssociation(
      request: zio.aws.deadline.model.CreateQueueFleetAssociationRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateQueueFleetAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueueFleetAssociation(request))
  def searchTasks(request: zio.aws.deadline.model.SearchTasksRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.SearchTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchTasks(request))
  def deleteFleet(request: zio.aws.deadline.model.DeleteFleetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleet(request))
  def updateStorageProfile(
      request: zio.aws.deadline.model.UpdateStorageProfileRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateStorageProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStorageProfile(request))
  def createMonitor(request: zio.aws.deadline.model.CreateMonitorRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMonitor(request))
  def listFarmMembers(
      request: zio.aws.deadline.model.ListFarmMembersRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.FarmMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listFarmMembers(request))
  def listFarmMembersPaginated(
      request: zio.aws.deadline.model.ListFarmMembersRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFarmMembersPaginated(request))
  def getStorageProfileForQueue(
      request: zio.aws.deadline.model.GetStorageProfileForQueueRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStorageProfileForQueue(request))
  def searchJobs(request: zio.aws.deadline.model.SearchJobsRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.SearchJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchJobs(request))
  def updateFleet(request: zio.aws.deadline.model.UpdateFleetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFleet(request))
  def getFleet(request: zio.aws.deadline.model.GetFleetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFleet(request))
  def listSessionsForWorker(
      request: zio.aws.deadline.model.ListSessionsForWorkerRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.WorkerSessionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSessionsForWorker(request))
  def listSessionsForWorkerPaginated(
      request: zio.aws.deadline.model.ListSessionsForWorkerRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSessionsForWorkerPaginated(request))
  def updateStep(request: zio.aws.deadline.model.UpdateStepRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStep(request))
  def listSteps(request: zio.aws.deadline.model.ListStepsRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.StepSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSteps(request))
  def listStepsPaginated(request: zio.aws.deadline.model.ListStepsRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStepsPaginated(request))
  def createFleet(request: zio.aws.deadline.model.CreateFleetRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleet(request))
  def searchWorkers(request: zio.aws.deadline.model.SearchWorkersRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.SearchWorkersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchWorkers(request))
  def deleteStorageProfile(
      request: zio.aws.deadline.model.DeleteStorageProfileRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteStorageProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStorageProfile(request))
  def getLicenseEndpoint(
      request: zio.aws.deadline.model.GetLicenseEndpointRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLicenseEndpoint(request))
  def untagResource(request: zio.aws.deadline.model.UntagResourceRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listWorkers(request: zio.aws.deadline.model.ListWorkersRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.WorkerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkers(request))
  def listWorkersPaginated(
      request: zio.aws.deadline.model.ListWorkersRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListWorkersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkersPaginated(request))
  def getJob(request: zio.aws.deadline.model.GetJobRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJob(request))
  def updateWorker(request: zio.aws.deadline.model.UpdateWorkerRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorker(request))
  def deleteQueueEnvironment(
      request: zio.aws.deadline.model.DeleteQueueEnvironmentRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteQueueEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueueEnvironment(request))
  def listSessionActions(
      request: zio.aws.deadline.model.ListSessionActionsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.SessionActionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSessionActions(request))
  def listSessionActionsPaginated(
      request: zio.aws.deadline.model.ListSessionActionsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSessionActionsPaginated(request))
  def listStepConsumers(
      request: zio.aws.deadline.model.ListStepConsumersRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.StepConsumer.ReadOnly
  ] = ZStream.serviceWithStream(_.listStepConsumers(request))
  def listStepConsumersPaginated(
      request: zio.aws.deadline.model.ListStepConsumersRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStepConsumersPaginated(request))
  def listJobParameterDefinitions(
      request: zio.aws.deadline.model.ListJobParameterDefinitionsRequest
  ): ZStream[zio.aws.deadline.Deadline, AwsError, Document] =
    ZStream.serviceWithStream(_.listJobParameterDefinitions(request))
  def listJobParameterDefinitionsPaginated(
      request: zio.aws.deadline.model.ListJobParameterDefinitionsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobParameterDefinitionsPaginated(request))
  def updateTask(request: zio.aws.deadline.model.UpdateTaskRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTask(request))
  def createQueue(request: zio.aws.deadline.model.CreateQueueRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueue(request))
  def deleteQueueFleetAssociation(
      request: zio.aws.deadline.model.DeleteQueueFleetAssociationRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteQueueFleetAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueueFleetAssociation(request))
  def copyJobTemplate(
      request: zio.aws.deadline.model.CopyJobTemplateRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyJobTemplate(request))
  def deleteLicenseEndpoint(
      request: zio.aws.deadline.model.DeleteLicenseEndpointRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteLicenseEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLicenseEndpoint(request))
  def getTask(request: zio.aws.deadline.model.GetTaskRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTask(request))
  def updateJob(request: zio.aws.deadline.model.UpdateJobRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateJob(request))
  def assumeQueueRoleForWorker(
      request: zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeQueueRoleForWorker(request))
  def getSessionAction(
      request: zio.aws.deadline.model.GetSessionActionRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetSessionActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSessionAction(request))
  def deleteMeteredProduct(
      request: zio.aws.deadline.model.DeleteMeteredProductRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteMeteredProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMeteredProduct(request))
  def listTagsForResource(
      request: zio.aws.deadline.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listJobs(request: zio.aws.deadline.model.ListJobsRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.JobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: zio.aws.deadline.model.ListJobsRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def listMeteredProducts(
      request: zio.aws.deadline.model.ListMeteredProductsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.MeteredProductSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMeteredProducts(request))
  def listMeteredProductsPaginated(
      request: zio.aws.deadline.model.ListMeteredProductsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListMeteredProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMeteredProductsPaginated(request))
  def tagResource(request: zio.aws.deadline.model.TagResourceRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getWorker(request: zio.aws.deadline.model.GetWorkerRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetWorkerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorker(request))
  def associateMemberToJob(
      request: zio.aws.deadline.model.AssociateMemberToJobRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssociateMemberToJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMemberToJob(request))
  def listSessions(
      request: zio.aws.deadline.model.ListSessionsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.SessionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSessions(request))
  def listSessionsPaginated(
      request: zio.aws.deadline.model.ListSessionsRequest
  ): ZIO[zio.aws.deadline.Deadline, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listSessionsPaginated(request))
  def listQueueMembers(
      request: zio.aws.deadline.model.ListQueueMembersRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.QueueMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueueMembers(request))
  def listQueueMembersPaginated(
      request: zio.aws.deadline.model.ListQueueMembersRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueueMembersPaginated(request))
  def listTasks(request: zio.aws.deadline.model.ListTasksRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.TaskSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTasks(request))
  def listTasksPaginated(request: zio.aws.deadline.model.ListTasksRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTasksPaginated(request))
  def getStorageProfile(
      request: zio.aws.deadline.model.GetStorageProfileRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStorageProfile(request))
  def updateFarm(request: zio.aws.deadline.model.UpdateFarmRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateFarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFarm(request))
  def getSession(request: zio.aws.deadline.model.GetSessionRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSession(request))
  def disassociateMemberFromJob(
      request: zio.aws.deadline.model.DisassociateMemberFromJobRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DisassociateMemberFromJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMemberFromJob(request))
  def listStepDependencies(
      request: zio.aws.deadline.model.ListStepDependenciesRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.StepDependency.ReadOnly
  ] = ZStream.serviceWithStream(_.listStepDependencies(request))
  def listStepDependenciesPaginated(
      request: zio.aws.deadline.model.ListStepDependenciesRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStepDependenciesPaginated(request))
  def updateSession(request: zio.aws.deadline.model.UpdateSessionRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.UpdateSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSession(request))
  def getMonitor(request: zio.aws.deadline.model.GetMonitorRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMonitor(request))
  def getQueue(request: zio.aws.deadline.model.GetQueueRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueue(request))
  def assumeFleetRoleForRead(
      request: zio.aws.deadline.model.AssumeFleetRoleForReadRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeFleetRoleForRead(request))
  def listBudgets(request: zio.aws.deadline.model.ListBudgetsRequest): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.BudgetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listBudgets(request))
  def listBudgetsPaginated(
      request: zio.aws.deadline.model.ListBudgetsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListBudgetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBudgetsPaginated(request))
  def getQueueFleetAssociation(
      request: zio.aws.deadline.model.GetQueueFleetAssociationRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueueFleetAssociation(request))
  def deleteQueue(request: zio.aws.deadline.model.DeleteQueueRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueue(request))
  def listQueueFleetAssociations(
      request: zio.aws.deadline.model.ListQueueFleetAssociationsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueueFleetAssociations(request))
  def listQueueFleetAssociationsPaginated(
      request: zio.aws.deadline.model.ListQueueFleetAssociationsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueueFleetAssociationsPaginated(request))
  def assumeQueueRoleForUser(
      request: zio.aws.deadline.model.AssumeQueueRoleForUserRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssumeQueueRoleForUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeQueueRoleForUser(request))
  def batchGetJobEntity(
      request: zio.aws.deadline.model.BatchGetJobEntityRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetJobEntity(request))
  def associateMemberToFarm(
      request: zio.aws.deadline.model.AssociateMemberToFarmRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.AssociateMemberToFarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMemberToFarm(request))
  def deleteFarm(request: zio.aws.deadline.model.DeleteFarmRequest): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.DeleteFarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFarm(request))
  def createQueueEnvironment(
      request: zio.aws.deadline.model.CreateQueueEnvironmentRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueueEnvironment(request))
  def listAvailableMeteredProducts(
      request: zio.aws.deadline.model.ListAvailableMeteredProductsRequest
  ): ZStream[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.MeteredProductSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAvailableMeteredProducts(request))
  def listAvailableMeteredProductsPaginated(
      request: zio.aws.deadline.model.ListAvailableMeteredProductsRequest
  ): ZIO[
    zio.aws.deadline.Deadline,
    AwsError,
    zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableMeteredProductsPaginated(request))
}
