package zio.aws.deadline
import zio.aws.deadline.model.ListSessionsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient
import zio.aws.core.AwsError
import zio.aws.deadline.model.{
  UpdateFarmRequest,
  GetBudgetRequest,
  ListFleetsRequest,
  SearchStepsRequest,
  ListWorkersRequest,
  UpdateSessionRequest,
  UpdateQueueEnvironmentRequest,
  AssumeFleetRoleForReadRequest,
  ListQueuesRequest,
  DeleteQueueRequest,
  GetFleetRequest,
  ListFarmsRequest,
  ListStepDependenciesRequest,
  ListJobParameterDefinitionsRequest,
  DeleteBudgetRequest,
  GetStepRequest,
  DeleteLicenseEndpointRequest,
  GetLicenseEndpointRequest,
  UpdateQueueFleetAssociationRequest,
  UpdateQueueRequest,
  GetQueueEnvironmentRequest,
  ListJobsRequest,
  DeleteMonitorRequest,
  GetTaskRequest,
  ListQueueMembersRequest,
  GetJobRequest,
  StartSessionsStatisticsAggregationRequest,
  CreateQueueRequest,
  UpdateStepRequest,
  CreateQueueEnvironmentRequest,
  DeleteMeteredProductRequest,
  SearchWorkersRequest,
  DeleteWorkerRequest,
  ListTagsForResourceRequest,
  ListStepsRequest,
  UpdateStorageProfileRequest,
  DisassociateMemberFromFleetRequest,
  GetStorageProfileForQueueRequest,
  ListAvailableMeteredProductsRequest,
  ListFleetMembersRequest,
  CreateLicenseEndpointRequest,
  CreateWorkerRequest,
  AssumeQueueRoleForReadRequest,
  PutMeteredProductRequest,
  CopyJobTemplateRequest,
  ListMonitorsRequest,
  DeleteFarmRequest,
  DisassociateMemberFromFarmRequest,
  ListSessionsForWorkerRequest,
  ListBudgetsRequest,
  ListLicenseEndpointsRequest,
  GetWorkerRequest,
  ListSessionsRequest,
  UpdateBudgetRequest,
  AssociateMemberToJobRequest,
  ListJobMembersRequest,
  ListMeteredProductsRequest,
  UpdateWorkerScheduleRequest,
  BatchGetJobEntityRequest,
  DeleteStorageProfileRequest,
  ListTasksRequest,
  AssociateMemberToFleetRequest,
  UpdateFleetRequest,
  CreateFleetRequest,
  GetStorageProfileRequest,
  UpdateMonitorRequest,
  AssumeFleetRoleForWorkerRequest,
  GetSessionRequest,
  GetSessionActionRequest,
  GetQueueFleetAssociationRequest,
  UntagResourceRequest,
  GetQueueRequest,
  DisassociateMemberFromJobRequest,
  UpdateWorkerRequest,
  CreateJobRequest,
  ListStorageProfilesForQueueRequest,
  ListFarmMembersRequest,
  ListQueueEnvironmentsRequest,
  UpdateJobRequest,
  AssumeQueueRoleForUserRequest,
  ListStorageProfilesRequest,
  AssociateMemberToQueueRequest,
  SearchJobsRequest,
  AssumeQueueRoleForWorkerRequest,
  CreateStorageProfileRequest,
  GetMonitorRequest,
  ListQueueFleetAssociationsRequest,
  GetFarmRequest,
  ListStepConsumersRequest,
  CreateQueueFleetAssociationRequest,
  ListSessionActionsRequest,
  AssociateMemberToFarmRequest,
  SearchTasksRequest,
  CreateBudgetRequest,
  DeleteQueueEnvironmentRequest,
  CreateFarmRequest,
  GetSessionsStatisticsAggregationRequest,
  UpdateTaskRequest,
  DeleteQueueFleetAssociationRequest,
  TagResourceRequest,
  DisassociateMemberFromQueueRequest,
  DeleteFleetRequest,
  CreateMonitorRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.core.document.Document
import zio.stream.ZStream
object DeadlineMock extends Mock[Deadline] {
  object AssociateMemberToFleet
      extends Effect[
        AssociateMemberToFleetRequest,
        AwsError,
        zio.aws.deadline.model.AssociateMemberToFleetResponse.ReadOnly
      ]
  object ListMonitors
      extends Stream[
        ListMonitorsRequest,
        AwsError,
        zio.aws.deadline.model.MonitorSummary.ReadOnly
      ]
  object ListMonitorsPaginated
      extends Effect[
        ListMonitorsRequest,
        AwsError,
        zio.aws.deadline.model.ListMonitorsResponse.ReadOnly
      ]
  object UpdateQueue
      extends Effect[
        UpdateQueueRequest,
        AwsError,
        zio.aws.deadline.model.UpdateQueueResponse.ReadOnly
      ]
  object AssociateMemberToQueue
      extends Effect[
        AssociateMemberToQueueRequest,
        AwsError,
        zio.aws.deadline.model.AssociateMemberToQueueResponse.ReadOnly
      ]
  object DeleteWorker
      extends Effect[
        DeleteWorkerRequest,
        AwsError,
        zio.aws.deadline.model.DeleteWorkerResponse.ReadOnly
      ]
  object SearchSteps
      extends Effect[
        SearchStepsRequest,
        AwsError,
        zio.aws.deadline.model.SearchStepsResponse.ReadOnly
      ]
  object UpdateQueueEnvironment
      extends Effect[
        UpdateQueueEnvironmentRequest,
        AwsError,
        zio.aws.deadline.model.UpdateQueueEnvironmentResponse.ReadOnly
      ]
  object GetBudget
      extends Effect[
        GetBudgetRequest,
        AwsError,
        zio.aws.deadline.model.GetBudgetResponse.ReadOnly
      ]
  object GetFarm
      extends Effect[
        GetFarmRequest,
        AwsError,
        zio.aws.deadline.model.GetFarmResponse.ReadOnly
      ]
  object StartSessionsStatisticsAggregation
      extends Effect[
        StartSessionsStatisticsAggregationRequest,
        AwsError,
        zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly
      ]
  object CreateLicenseEndpoint
      extends Effect[
        CreateLicenseEndpointRequest,
        AwsError,
        zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly
      ]
  object UpdateMonitor
      extends Effect[
        UpdateMonitorRequest,
        AwsError,
        zio.aws.deadline.model.UpdateMonitorResponse.ReadOnly
      ]
  object ListFleetMembers
      extends Stream[
        ListFleetMembersRequest,
        AwsError,
        zio.aws.deadline.model.FleetMember.ReadOnly
      ]
  object ListFleetMembersPaginated
      extends Effect[
        ListFleetMembersRequest,
        AwsError,
        zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly
      ]
  object GetQueueEnvironment
      extends Effect[
        GetQueueEnvironmentRequest,
        AwsError,
        zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly
      ]
  object PutMeteredProduct
      extends Effect[
        PutMeteredProductRequest,
        AwsError,
        zio.aws.deadline.model.PutMeteredProductResponse.ReadOnly
      ]
  object ListStorageProfiles
      extends Stream[
        ListStorageProfilesRequest,
        AwsError,
        zio.aws.deadline.model.StorageProfileSummary.ReadOnly
      ]
  object ListStorageProfilesPaginated
      extends Effect[
        ListStorageProfilesRequest,
        AwsError,
        zio.aws.deadline.model.ListStorageProfilesResponse.ReadOnly
      ]
  object CreateWorker
      extends Effect[
        CreateWorkerRequest,
        AwsError,
        zio.aws.deadline.model.CreateWorkerResponse.ReadOnly
      ]
  object UpdateWorkerSchedule
      extends Effect[
        UpdateWorkerScheduleRequest,
        AwsError,
        zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly
      ]
  object ListFarms
      extends Stream[
        ListFarmsRequest,
        AwsError,
        zio.aws.deadline.model.FarmSummary.ReadOnly
      ]
  object ListFarmsPaginated
      extends Effect[
        ListFarmsRequest,
        AwsError,
        zio.aws.deadline.model.ListFarmsResponse.ReadOnly
      ]
  object CreateStorageProfile
      extends Effect[
        CreateStorageProfileRequest,
        AwsError,
        zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly
      ]
  object DeleteBudget
      extends Effect[
        DeleteBudgetRequest,
        AwsError,
        zio.aws.deadline.model.DeleteBudgetResponse.ReadOnly
      ]
  object CreateBudget
      extends Effect[
        CreateBudgetRequest,
        AwsError,
        zio.aws.deadline.model.CreateBudgetResponse.ReadOnly
      ]
  object DisassociateMemberFromFarm
      extends Effect[
        DisassociateMemberFromFarmRequest,
        AwsError,
        zio.aws.deadline.model.DisassociateMemberFromFarmResponse.ReadOnly
      ]
  object AssumeQueueRoleForRead
      extends Effect[
        AssumeQueueRoleForReadRequest,
        AwsError,
        zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly
      ]
  object DisassociateMemberFromQueue
      extends Effect[
        DisassociateMemberFromQueueRequest,
        AwsError,
        zio.aws.deadline.model.DisassociateMemberFromQueueResponse.ReadOnly
      ]
  object GetStep
      extends Effect[
        GetStepRequest,
        AwsError,
        zio.aws.deadline.model.GetStepResponse.ReadOnly
      ]
  object ListFleets
      extends Stream[
        ListFleetsRequest,
        AwsError,
        zio.aws.deadline.model.FleetSummary.ReadOnly
      ]
  object ListFleetsPaginated
      extends Effect[
        ListFleetsRequest,
        AwsError,
        zio.aws.deadline.model.ListFleetsResponse.ReadOnly
      ]
  object DisassociateMemberFromFleet
      extends Effect[
        DisassociateMemberFromFleetRequest,
        AwsError,
        zio.aws.deadline.model.DisassociateMemberFromFleetResponse.ReadOnly
      ]
  object ListQueues
      extends Stream[
        ListQueuesRequest,
        AwsError,
        zio.aws.deadline.model.QueueSummary.ReadOnly
      ]
  object ListQueuesPaginated
      extends Effect[
        ListQueuesRequest,
        AwsError,
        zio.aws.deadline.model.ListQueuesResponse.ReadOnly
      ]
  object AssumeFleetRoleForWorker
      extends Effect[
        AssumeFleetRoleForWorkerRequest,
        AwsError,
        zio.aws.deadline.model.AssumeFleetRoleForWorkerResponse.ReadOnly
      ]
  object ListQueueEnvironments
      extends Stream[
        ListQueueEnvironmentsRequest,
        AwsError,
        zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly
      ]
  object ListQueueEnvironmentsPaginated
      extends Effect[
        ListQueueEnvironmentsRequest,
        AwsError,
        zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly
      ]
  object UpdateQueueFleetAssociation
      extends Effect[
        UpdateQueueFleetAssociationRequest,
        AwsError,
        zio.aws.deadline.model.UpdateQueueFleetAssociationResponse.ReadOnly
      ]
  object ListLicenseEndpoints
      extends Stream[
        ListLicenseEndpointsRequest,
        AwsError,
        zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly
      ]
  object ListLicenseEndpointsPaginated
      extends Effect[
        ListLicenseEndpointsRequest,
        AwsError,
        zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly
      ]
  object ListStorageProfilesForQueue
      extends Stream[
        ListStorageProfilesForQueueRequest,
        AwsError,
        zio.aws.deadline.model.StorageProfileSummary.ReadOnly
      ]
  object ListStorageProfilesForQueuePaginated
      extends Effect[
        ListStorageProfilesForQueueRequest,
        AwsError,
        zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly
      ]
  object ListJobMembers
      extends Stream[
        ListJobMembersRequest,
        AwsError,
        zio.aws.deadline.model.JobMember.ReadOnly
      ]
  object ListJobMembersPaginated
      extends Effect[
        ListJobMembersRequest,
        AwsError,
        zio.aws.deadline.model.ListJobMembersResponse.ReadOnly
      ]
  object CreateJob
      extends Effect[
        CreateJobRequest,
        AwsError,
        zio.aws.deadline.model.CreateJobResponse.ReadOnly
      ]
  object DeleteMonitor
      extends Effect[
        DeleteMonitorRequest,
        AwsError,
        zio.aws.deadline.model.DeleteMonitorResponse.ReadOnly
      ]
  object UpdateBudget
      extends Effect[
        UpdateBudgetRequest,
        AwsError,
        zio.aws.deadline.model.UpdateBudgetResponse.ReadOnly
      ]
  object GetSessionsStatisticsAggregation
      extends Stream[
        GetSessionsStatisticsAggregationRequest,
        AwsError,
        zio.aws.deadline.model.Statistics.ReadOnly
      ]
  object GetSessionsStatisticsAggregationPaginated
      extends Effect[
        GetSessionsStatisticsAggregationRequest,
        AwsError,
        zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly
      ]
  object CreateFarm
      extends Effect[
        CreateFarmRequest,
        AwsError,
        zio.aws.deadline.model.CreateFarmResponse.ReadOnly
      ]
  object CreateQueueFleetAssociation
      extends Effect[
        CreateQueueFleetAssociationRequest,
        AwsError,
        zio.aws.deadline.model.CreateQueueFleetAssociationResponse.ReadOnly
      ]
  object SearchTasks
      extends Effect[
        SearchTasksRequest,
        AwsError,
        zio.aws.deadline.model.SearchTasksResponse.ReadOnly
      ]
  object DeleteFleet
      extends Effect[
        DeleteFleetRequest,
        AwsError,
        zio.aws.deadline.model.DeleteFleetResponse.ReadOnly
      ]
  object UpdateStorageProfile
      extends Effect[
        UpdateStorageProfileRequest,
        AwsError,
        zio.aws.deadline.model.UpdateStorageProfileResponse.ReadOnly
      ]
  object CreateMonitor
      extends Effect[
        CreateMonitorRequest,
        AwsError,
        zio.aws.deadline.model.CreateMonitorResponse.ReadOnly
      ]
  object ListFarmMembers
      extends Stream[
        ListFarmMembersRequest,
        AwsError,
        zio.aws.deadline.model.FarmMember.ReadOnly
      ]
  object ListFarmMembersPaginated
      extends Effect[
        ListFarmMembersRequest,
        AwsError,
        zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly
      ]
  object GetStorageProfileForQueue
      extends Effect[
        GetStorageProfileForQueueRequest,
        AwsError,
        zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly
      ]
  object SearchJobs
      extends Effect[
        SearchJobsRequest,
        AwsError,
        zio.aws.deadline.model.SearchJobsResponse.ReadOnly
      ]
  object UpdateFleet
      extends Effect[
        UpdateFleetRequest,
        AwsError,
        zio.aws.deadline.model.UpdateFleetResponse.ReadOnly
      ]
  object GetFleet
      extends Effect[
        GetFleetRequest,
        AwsError,
        zio.aws.deadline.model.GetFleetResponse.ReadOnly
      ]
  object ListSessionsForWorker
      extends Stream[
        ListSessionsForWorkerRequest,
        AwsError,
        zio.aws.deadline.model.WorkerSessionSummary.ReadOnly
      ]
  object ListSessionsForWorkerPaginated
      extends Effect[
        ListSessionsForWorkerRequest,
        AwsError,
        zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly
      ]
  object UpdateStep
      extends Effect[
        UpdateStepRequest,
        AwsError,
        zio.aws.deadline.model.UpdateStepResponse.ReadOnly
      ]
  object ListSteps
      extends Stream[
        ListStepsRequest,
        AwsError,
        zio.aws.deadline.model.StepSummary.ReadOnly
      ]
  object ListStepsPaginated
      extends Effect[
        ListStepsRequest,
        AwsError,
        zio.aws.deadline.model.ListStepsResponse.ReadOnly
      ]
  object CreateFleet
      extends Effect[
        CreateFleetRequest,
        AwsError,
        zio.aws.deadline.model.CreateFleetResponse.ReadOnly
      ]
  object SearchWorkers
      extends Effect[
        SearchWorkersRequest,
        AwsError,
        zio.aws.deadline.model.SearchWorkersResponse.ReadOnly
      ]
  object DeleteStorageProfile
      extends Effect[
        DeleteStorageProfileRequest,
        AwsError,
        zio.aws.deadline.model.DeleteStorageProfileResponse.ReadOnly
      ]
  object GetLicenseEndpoint
      extends Effect[
        GetLicenseEndpointRequest,
        AwsError,
        zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.deadline.model.UntagResourceResponse.ReadOnly
      ]
  object ListWorkers
      extends Stream[
        ListWorkersRequest,
        AwsError,
        zio.aws.deadline.model.WorkerSummary.ReadOnly
      ]
  object ListWorkersPaginated
      extends Effect[
        ListWorkersRequest,
        AwsError,
        zio.aws.deadline.model.ListWorkersResponse.ReadOnly
      ]
  object GetJob
      extends Effect[
        GetJobRequest,
        AwsError,
        zio.aws.deadline.model.GetJobResponse.ReadOnly
      ]
  object UpdateWorker
      extends Effect[
        UpdateWorkerRequest,
        AwsError,
        zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly
      ]
  object DeleteQueueEnvironment
      extends Effect[
        DeleteQueueEnvironmentRequest,
        AwsError,
        zio.aws.deadline.model.DeleteQueueEnvironmentResponse.ReadOnly
      ]
  object ListSessionActions
      extends Stream[
        ListSessionActionsRequest,
        AwsError,
        zio.aws.deadline.model.SessionActionSummary.ReadOnly
      ]
  object ListSessionActionsPaginated
      extends Effect[
        ListSessionActionsRequest,
        AwsError,
        zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly
      ]
  object ListStepConsumers
      extends Stream[
        ListStepConsumersRequest,
        AwsError,
        zio.aws.deadline.model.StepConsumer.ReadOnly
      ]
  object ListStepConsumersPaginated
      extends Effect[
        ListStepConsumersRequest,
        AwsError,
        zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly
      ]
  object ListJobParameterDefinitions
      extends Stream[ListJobParameterDefinitionsRequest, AwsError, Document]
  object ListJobParameterDefinitionsPaginated
      extends Effect[
        ListJobParameterDefinitionsRequest,
        AwsError,
        zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly
      ]
  object UpdateTask
      extends Effect[
        UpdateTaskRequest,
        AwsError,
        zio.aws.deadline.model.UpdateTaskResponse.ReadOnly
      ]
  object CreateQueue
      extends Effect[
        CreateQueueRequest,
        AwsError,
        zio.aws.deadline.model.CreateQueueResponse.ReadOnly
      ]
  object DeleteQueueFleetAssociation
      extends Effect[
        DeleteQueueFleetAssociationRequest,
        AwsError,
        zio.aws.deadline.model.DeleteQueueFleetAssociationResponse.ReadOnly
      ]
  object CopyJobTemplate
      extends Effect[
        CopyJobTemplateRequest,
        AwsError,
        zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly
      ]
  object DeleteLicenseEndpoint
      extends Effect[
        DeleteLicenseEndpointRequest,
        AwsError,
        zio.aws.deadline.model.DeleteLicenseEndpointResponse.ReadOnly
      ]
  object GetTask
      extends Effect[
        GetTaskRequest,
        AwsError,
        zio.aws.deadline.model.GetTaskResponse.ReadOnly
      ]
  object UpdateJob
      extends Effect[
        UpdateJobRequest,
        AwsError,
        zio.aws.deadline.model.UpdateJobResponse.ReadOnly
      ]
  object AssumeQueueRoleForWorker
      extends Effect[
        AssumeQueueRoleForWorkerRequest,
        AwsError,
        zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly
      ]
  object GetSessionAction
      extends Effect[
        GetSessionActionRequest,
        AwsError,
        zio.aws.deadline.model.GetSessionActionResponse.ReadOnly
      ]
  object DeleteMeteredProduct
      extends Effect[
        DeleteMeteredProductRequest,
        AwsError,
        zio.aws.deadline.model.DeleteMeteredProductResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.deadline.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.deadline.model.JobSummary.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.deadline.model.ListJobsResponse.ReadOnly
      ]
  object ListMeteredProducts
      extends Stream[
        ListMeteredProductsRequest,
        AwsError,
        zio.aws.deadline.model.MeteredProductSummary.ReadOnly
      ]
  object ListMeteredProductsPaginated
      extends Effect[
        ListMeteredProductsRequest,
        AwsError,
        zio.aws.deadline.model.ListMeteredProductsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.deadline.model.TagResourceResponse.ReadOnly
      ]
  object GetWorker
      extends Effect[
        GetWorkerRequest,
        AwsError,
        zio.aws.deadline.model.GetWorkerResponse.ReadOnly
      ]
  object AssociateMemberToJob
      extends Effect[
        AssociateMemberToJobRequest,
        AwsError,
        zio.aws.deadline.model.AssociateMemberToJobResponse.ReadOnly
      ]
  object ListSessions
      extends Stream[
        ListSessionsRequest,
        AwsError,
        zio.aws.deadline.model.SessionSummary.ReadOnly
      ]
  object ListSessionsPaginated
      extends Effect[ListSessionsRequest, AwsError, ReadOnly]
  object ListQueueMembers
      extends Stream[
        ListQueueMembersRequest,
        AwsError,
        zio.aws.deadline.model.QueueMember.ReadOnly
      ]
  object ListQueueMembersPaginated
      extends Effect[
        ListQueueMembersRequest,
        AwsError,
        zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly
      ]
  object ListTasks
      extends Stream[
        ListTasksRequest,
        AwsError,
        zio.aws.deadline.model.TaskSummary.ReadOnly
      ]
  object ListTasksPaginated
      extends Effect[
        ListTasksRequest,
        AwsError,
        zio.aws.deadline.model.ListTasksResponse.ReadOnly
      ]
  object GetStorageProfile
      extends Effect[
        GetStorageProfileRequest,
        AwsError,
        zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly
      ]
  object UpdateFarm
      extends Effect[
        UpdateFarmRequest,
        AwsError,
        zio.aws.deadline.model.UpdateFarmResponse.ReadOnly
      ]
  object GetSession
      extends Effect[
        GetSessionRequest,
        AwsError,
        zio.aws.deadline.model.GetSessionResponse.ReadOnly
      ]
  object DisassociateMemberFromJob
      extends Effect[
        DisassociateMemberFromJobRequest,
        AwsError,
        zio.aws.deadline.model.DisassociateMemberFromJobResponse.ReadOnly
      ]
  object ListStepDependencies
      extends Stream[
        ListStepDependenciesRequest,
        AwsError,
        zio.aws.deadline.model.StepDependency.ReadOnly
      ]
  object ListStepDependenciesPaginated
      extends Effect[
        ListStepDependenciesRequest,
        AwsError,
        zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly
      ]
  object UpdateSession
      extends Effect[
        UpdateSessionRequest,
        AwsError,
        zio.aws.deadline.model.UpdateSessionResponse.ReadOnly
      ]
  object GetMonitor
      extends Effect[
        GetMonitorRequest,
        AwsError,
        zio.aws.deadline.model.GetMonitorResponse.ReadOnly
      ]
  object GetQueue
      extends Effect[
        GetQueueRequest,
        AwsError,
        zio.aws.deadline.model.GetQueueResponse.ReadOnly
      ]
  object AssumeFleetRoleForRead
      extends Effect[
        AssumeFleetRoleForReadRequest,
        AwsError,
        zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly
      ]
  object ListBudgets
      extends Stream[
        ListBudgetsRequest,
        AwsError,
        zio.aws.deadline.model.BudgetSummary.ReadOnly
      ]
  object ListBudgetsPaginated
      extends Effect[
        ListBudgetsRequest,
        AwsError,
        zio.aws.deadline.model.ListBudgetsResponse.ReadOnly
      ]
  object GetQueueFleetAssociation
      extends Effect[
        GetQueueFleetAssociationRequest,
        AwsError,
        zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly
      ]
  object DeleteQueue
      extends Effect[
        DeleteQueueRequest,
        AwsError,
        zio.aws.deadline.model.DeleteQueueResponse.ReadOnly
      ]
  object ListQueueFleetAssociations
      extends Stream[
        ListQueueFleetAssociationsRequest,
        AwsError,
        zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly
      ]
  object ListQueueFleetAssociationsPaginated
      extends Effect[
        ListQueueFleetAssociationsRequest,
        AwsError,
        zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly
      ]
  object AssumeQueueRoleForUser
      extends Effect[
        AssumeQueueRoleForUserRequest,
        AwsError,
        zio.aws.deadline.model.AssumeQueueRoleForUserResponse.ReadOnly
      ]
  object BatchGetJobEntity
      extends Effect[
        BatchGetJobEntityRequest,
        AwsError,
        zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly
      ]
  object AssociateMemberToFarm
      extends Effect[
        AssociateMemberToFarmRequest,
        AwsError,
        zio.aws.deadline.model.AssociateMemberToFarmResponse.ReadOnly
      ]
  object DeleteFarm
      extends Effect[
        DeleteFarmRequest,
        AwsError,
        zio.aws.deadline.model.DeleteFarmResponse.ReadOnly
      ]
  object CreateQueueEnvironment
      extends Effect[
        CreateQueueEnvironmentRequest,
        AwsError,
        zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly
      ]
  object ListAvailableMeteredProducts
      extends Stream[
        ListAvailableMeteredProductsRequest,
        AwsError,
        zio.aws.deadline.model.MeteredProductSummary.ReadOnly
      ]
  object ListAvailableMeteredProductsPaginated
      extends Effect[
        ListAvailableMeteredProductsRequest,
        AwsError,
        zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Deadline] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Deadline] { rts =>
        zio.ZIO.succeed {
          new Deadline {
            val api: DeadlineAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Deadline = this
            def associateMemberToFleet(
                request: AssociateMemberToFleetRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssociateMemberToFleetResponse.ReadOnly
            ] = proxy(AssociateMemberToFleet, request)
            def listMonitors(request: ListMonitorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.MonitorSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMonitors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMonitorsPaginated(request: ListMonitorsRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListMonitorsResponse.ReadOnly
            ] = proxy(ListMonitorsPaginated, request)
            def updateQueue(request: UpdateQueueRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateQueueResponse.ReadOnly
            ] = proxy(UpdateQueue, request)
            def associateMemberToQueue(
                request: AssociateMemberToQueueRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssociateMemberToQueueResponse.ReadOnly
            ] = proxy(AssociateMemberToQueue, request)
            def deleteWorker(request: DeleteWorkerRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteWorkerResponse.ReadOnly
            ] = proxy(DeleteWorker, request)
            def searchSteps(request: SearchStepsRequest): IO[
              AwsError,
              zio.aws.deadline.model.SearchStepsResponse.ReadOnly
            ] = proxy(SearchSteps, request)
            def updateQueueEnvironment(
                request: UpdateQueueEnvironmentRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.UpdateQueueEnvironmentResponse.ReadOnly
            ] = proxy(UpdateQueueEnvironment, request)
            def getBudget(
                request: GetBudgetRequest
            ): IO[AwsError, zio.aws.deadline.model.GetBudgetResponse.ReadOnly] =
              proxy(GetBudget, request)
            def getFarm(
                request: GetFarmRequest
            ): IO[AwsError, zio.aws.deadline.model.GetFarmResponse.ReadOnly] =
              proxy(GetFarm, request)
            def startSessionsStatisticsAggregation(
                request: StartSessionsStatisticsAggregationRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.StartSessionsStatisticsAggregationResponse.ReadOnly
            ] = proxy(StartSessionsStatisticsAggregation, request)
            def createLicenseEndpoint(
                request: CreateLicenseEndpointRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.CreateLicenseEndpointResponse.ReadOnly
            ] = proxy(CreateLicenseEndpoint, request)
            def updateMonitor(request: UpdateMonitorRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateMonitorResponse.ReadOnly
            ] = proxy(UpdateMonitor, request)
            def listFleetMembers(request: ListFleetMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.FleetMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFleetMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFleetMembersPaginated(request: ListFleetMembersRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListFleetMembersResponse.ReadOnly
            ] = proxy(ListFleetMembersPaginated, request)
            def getQueueEnvironment(request: GetQueueEnvironmentRequest): IO[
              AwsError,
              zio.aws.deadline.model.GetQueueEnvironmentResponse.ReadOnly
            ] = proxy(GetQueueEnvironment, request)
            def putMeteredProduct(request: PutMeteredProductRequest): IO[
              AwsError,
              zio.aws.deadline.model.PutMeteredProductResponse.ReadOnly
            ] = proxy(PutMeteredProduct, request)
            def listStorageProfiles(
                request: ListStorageProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.StorageProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStorageProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStorageProfilesPaginated(
                request: ListStorageProfilesRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListStorageProfilesResponse.ReadOnly
            ] = proxy(ListStorageProfilesPaginated, request)
            def createWorker(request: CreateWorkerRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateWorkerResponse.ReadOnly
            ] = proxy(CreateWorker, request)
            def updateWorkerSchedule(request: UpdateWorkerScheduleRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateWorkerScheduleResponse.ReadOnly
            ] = proxy(UpdateWorkerSchedule, request)
            def listFarms(request: ListFarmsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.FarmSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFarms, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFarmsPaginated(
                request: ListFarmsRequest
            ): IO[AwsError, zio.aws.deadline.model.ListFarmsResponse.ReadOnly] =
              proxy(ListFarmsPaginated, request)
            def createStorageProfile(request: CreateStorageProfileRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateStorageProfileResponse.ReadOnly
            ] = proxy(CreateStorageProfile, request)
            def deleteBudget(request: DeleteBudgetRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteBudgetResponse.ReadOnly
            ] = proxy(DeleteBudget, request)
            def createBudget(request: CreateBudgetRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateBudgetResponse.ReadOnly
            ] = proxy(CreateBudget, request)
            def disassociateMemberFromFarm(
                request: DisassociateMemberFromFarmRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DisassociateMemberFromFarmResponse.ReadOnly
            ] = proxy(DisassociateMemberFromFarm, request)
            def assumeQueueRoleForRead(
                request: AssumeQueueRoleForReadRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly
            ] = proxy(AssumeQueueRoleForRead, request)
            def disassociateMemberFromQueue(
                request: DisassociateMemberFromQueueRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DisassociateMemberFromQueueResponse.ReadOnly
            ] = proxy(DisassociateMemberFromQueue, request)
            def getStep(
                request: GetStepRequest
            ): IO[AwsError, zio.aws.deadline.model.GetStepResponse.ReadOnly] =
              proxy(GetStep, request)
            def listFleets(request: ListFleetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.FleetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFleets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFleetsPaginated(request: ListFleetsRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListFleetsResponse.ReadOnly
            ] = proxy(ListFleetsPaginated, request)
            def disassociateMemberFromFleet(
                request: DisassociateMemberFromFleetRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DisassociateMemberFromFleetResponse.ReadOnly
            ] = proxy(DisassociateMemberFromFleet, request)
            def listQueues(request: ListQueuesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.QueueSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueues, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueuesPaginated(request: ListQueuesRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListQueuesResponse.ReadOnly
            ] = proxy(ListQueuesPaginated, request)
            def assumeFleetRoleForWorker(
                request: AssumeFleetRoleForWorkerRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssumeFleetRoleForWorkerResponse.ReadOnly
            ] = proxy(AssumeFleetRoleForWorker, request)
            def listQueueEnvironments(
                request: ListQueueEnvironmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.QueueEnvironmentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueueEnvironments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueueEnvironmentsPaginated(
                request: ListQueueEnvironmentsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListQueueEnvironmentsResponse.ReadOnly
            ] = proxy(ListQueueEnvironmentsPaginated, request)
            def updateQueueFleetAssociation(
                request: UpdateQueueFleetAssociationRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.UpdateQueueFleetAssociationResponse.ReadOnly
            ] = proxy(UpdateQueueFleetAssociation, request)
            def listLicenseEndpoints(
                request: ListLicenseEndpointsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.LicenseEndpointSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLicenseEndpoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLicenseEndpointsPaginated(
                request: ListLicenseEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListLicenseEndpointsResponse.ReadOnly
            ] = proxy(ListLicenseEndpointsPaginated, request)
            def listStorageProfilesForQueue(
                request: ListStorageProfilesForQueueRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.StorageProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStorageProfilesForQueue, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStorageProfilesForQueuePaginated(
                request: ListStorageProfilesForQueueRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListStorageProfilesForQueueResponse.ReadOnly
            ] = proxy(ListStorageProfilesForQueuePaginated, request)
            def listJobMembers(request: ListJobMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.JobMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListJobMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listJobMembersPaginated(request: ListJobMembersRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListJobMembersResponse.ReadOnly
            ] = proxy(ListJobMembersPaginated, request)
            def createJob(
                request: CreateJobRequest
            ): IO[AwsError, zio.aws.deadline.model.CreateJobResponse.ReadOnly] =
              proxy(CreateJob, request)
            def deleteMonitor(request: DeleteMonitorRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteMonitorResponse.ReadOnly
            ] = proxy(DeleteMonitor, request)
            def updateBudget(request: UpdateBudgetRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateBudgetResponse.ReadOnly
            ] = proxy(UpdateBudget, request)
            def getSessionsStatisticsAggregation(
                request: GetSessionsStatisticsAggregationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.Statistics.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetSessionsStatisticsAggregation, request)
                }
                .getOrThrowFiberFailure()
            }
            def getSessionsStatisticsAggregationPaginated(
                request: GetSessionsStatisticsAggregationRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.GetSessionsStatisticsAggregationResponse.ReadOnly
            ] = proxy(GetSessionsStatisticsAggregationPaginated, request)
            def createFarm(request: CreateFarmRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateFarmResponse.ReadOnly
            ] = proxy(CreateFarm, request)
            def createQueueFleetAssociation(
                request: CreateQueueFleetAssociationRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.CreateQueueFleetAssociationResponse.ReadOnly
            ] = proxy(CreateQueueFleetAssociation, request)
            def searchTasks(request: SearchTasksRequest): IO[
              AwsError,
              zio.aws.deadline.model.SearchTasksResponse.ReadOnly
            ] = proxy(SearchTasks, request)
            def deleteFleet(request: DeleteFleetRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteFleetResponse.ReadOnly
            ] = proxy(DeleteFleet, request)
            def updateStorageProfile(request: UpdateStorageProfileRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateStorageProfileResponse.ReadOnly
            ] = proxy(UpdateStorageProfile, request)
            def createMonitor(request: CreateMonitorRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateMonitorResponse.ReadOnly
            ] = proxy(CreateMonitor, request)
            def listFarmMembers(request: ListFarmMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.FarmMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFarmMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFarmMembersPaginated(request: ListFarmMembersRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListFarmMembersResponse.ReadOnly
            ] = proxy(ListFarmMembersPaginated, request)
            def getStorageProfileForQueue(
                request: GetStorageProfileForQueueRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.GetStorageProfileForQueueResponse.ReadOnly
            ] = proxy(GetStorageProfileForQueue, request)
            def searchJobs(request: SearchJobsRequest): IO[
              AwsError,
              zio.aws.deadline.model.SearchJobsResponse.ReadOnly
            ] = proxy(SearchJobs, request)
            def updateFleet(request: UpdateFleetRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateFleetResponse.ReadOnly
            ] = proxy(UpdateFleet, request)
            def getFleet(
                request: GetFleetRequest
            ): IO[AwsError, zio.aws.deadline.model.GetFleetResponse.ReadOnly] =
              proxy(GetFleet, request)
            def listSessionsForWorker(
                request: ListSessionsForWorkerRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.WorkerSessionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSessionsForWorker, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSessionsForWorkerPaginated(
                request: ListSessionsForWorkerRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListSessionsForWorkerResponse.ReadOnly
            ] = proxy(ListSessionsForWorkerPaginated, request)
            def updateStep(request: UpdateStepRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateStepResponse.ReadOnly
            ] = proxy(UpdateStep, request)
            def listSteps(request: ListStepsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.StepSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSteps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStepsPaginated(
                request: ListStepsRequest
            ): IO[AwsError, zio.aws.deadline.model.ListStepsResponse.ReadOnly] =
              proxy(ListStepsPaginated, request)
            def createFleet(request: CreateFleetRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateFleetResponse.ReadOnly
            ] = proxy(CreateFleet, request)
            def searchWorkers(request: SearchWorkersRequest): IO[
              AwsError,
              zio.aws.deadline.model.SearchWorkersResponse.ReadOnly
            ] = proxy(SearchWorkers, request)
            def deleteStorageProfile(request: DeleteStorageProfileRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteStorageProfileResponse.ReadOnly
            ] = proxy(DeleteStorageProfile, request)
            def getLicenseEndpoint(request: GetLicenseEndpointRequest): IO[
              AwsError,
              zio.aws.deadline.model.GetLicenseEndpointResponse.ReadOnly
            ] = proxy(GetLicenseEndpoint, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.deadline.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listWorkers(request: ListWorkersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.WorkerSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkersPaginated(request: ListWorkersRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListWorkersResponse.ReadOnly
            ] = proxy(ListWorkersPaginated, request)
            def getJob(
                request: GetJobRequest
            ): IO[AwsError, zio.aws.deadline.model.GetJobResponse.ReadOnly] =
              proxy(GetJob, request)
            def updateWorker(request: UpdateWorkerRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateWorkerResponse.ReadOnly
            ] = proxy(UpdateWorker, request)
            def deleteQueueEnvironment(
                request: DeleteQueueEnvironmentRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DeleteQueueEnvironmentResponse.ReadOnly
            ] = proxy(DeleteQueueEnvironment, request)
            def listSessionActions(request: ListSessionActionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.SessionActionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSessionActions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSessionActionsPaginated(
                request: ListSessionActionsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListSessionActionsResponse.ReadOnly
            ] = proxy(ListSessionActionsPaginated, request)
            def listStepConsumers(request: ListStepConsumersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.StepConsumer.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStepConsumers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStepConsumersPaginated(
                request: ListStepConsumersRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListStepConsumersResponse.ReadOnly
            ] = proxy(ListStepConsumersPaginated, request)
            def listJobParameterDefinitions(
                request: ListJobParameterDefinitionsRequest
            ): ZStream[Any, AwsError, Document] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListJobParameterDefinitions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listJobParameterDefinitionsPaginated(
                request: ListJobParameterDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListJobParameterDefinitionsResponse.ReadOnly
            ] = proxy(ListJobParameterDefinitionsPaginated, request)
            def updateTask(request: UpdateTaskRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateTaskResponse.ReadOnly
            ] = proxy(UpdateTask, request)
            def createQueue(request: CreateQueueRequest): IO[
              AwsError,
              zio.aws.deadline.model.CreateQueueResponse.ReadOnly
            ] = proxy(CreateQueue, request)
            def deleteQueueFleetAssociation(
                request: DeleteQueueFleetAssociationRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DeleteQueueFleetAssociationResponse.ReadOnly
            ] = proxy(DeleteQueueFleetAssociation, request)
            def copyJobTemplate(request: CopyJobTemplateRequest): IO[
              AwsError,
              zio.aws.deadline.model.CopyJobTemplateResponse.ReadOnly
            ] = proxy(CopyJobTemplate, request)
            def deleteLicenseEndpoint(
                request: DeleteLicenseEndpointRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DeleteLicenseEndpointResponse.ReadOnly
            ] = proxy(DeleteLicenseEndpoint, request)
            def getTask(
                request: GetTaskRequest
            ): IO[AwsError, zio.aws.deadline.model.GetTaskResponse.ReadOnly] =
              proxy(GetTask, request)
            def updateJob(
                request: UpdateJobRequest
            ): IO[AwsError, zio.aws.deadline.model.UpdateJobResponse.ReadOnly] =
              proxy(UpdateJob, request)
            def assumeQueueRoleForWorker(
                request: AssumeQueueRoleForWorkerRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly
            ] = proxy(AssumeQueueRoleForWorker, request)
            def getSessionAction(request: GetSessionActionRequest): IO[
              AwsError,
              zio.aws.deadline.model.GetSessionActionResponse.ReadOnly
            ] = proxy(GetSessionAction, request)
            def deleteMeteredProduct(request: DeleteMeteredProductRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteMeteredProductResponse.ReadOnly
            ] = proxy(DeleteMeteredProduct, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listJobs(request: ListJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.JobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listJobsPaginated(
                request: ListJobsRequest
            ): IO[AwsError, zio.aws.deadline.model.ListJobsResponse.ReadOnly] =
              proxy(ListJobsPaginated, request)
            def listMeteredProducts(
                request: ListMeteredProductsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.MeteredProductSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMeteredProducts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMeteredProductsPaginated(
                request: ListMeteredProductsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListMeteredProductsResponse.ReadOnly
            ] = proxy(ListMeteredProductsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.deadline.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getWorker(
                request: GetWorkerRequest
            ): IO[AwsError, zio.aws.deadline.model.GetWorkerResponse.ReadOnly] =
              proxy(GetWorker, request)
            def associateMemberToJob(request: AssociateMemberToJobRequest): IO[
              AwsError,
              zio.aws.deadline.model.AssociateMemberToJobResponse.ReadOnly
            ] = proxy(AssociateMemberToJob, request)
            def listSessions(request: ListSessionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.SessionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSessions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSessionsPaginated(
                request: ListSessionsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListSessionsPaginated, request)
            def listQueueMembers(request: ListQueueMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.QueueMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueueMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueueMembersPaginated(request: ListQueueMembersRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListQueueMembersResponse.ReadOnly
            ] = proxy(ListQueueMembersPaginated, request)
            def listTasks(request: ListTasksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.TaskSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTasks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTasksPaginated(
                request: ListTasksRequest
            ): IO[AwsError, zio.aws.deadline.model.ListTasksResponse.ReadOnly] =
              proxy(ListTasksPaginated, request)
            def getStorageProfile(request: GetStorageProfileRequest): IO[
              AwsError,
              zio.aws.deadline.model.GetStorageProfileResponse.ReadOnly
            ] = proxy(GetStorageProfile, request)
            def updateFarm(request: UpdateFarmRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateFarmResponse.ReadOnly
            ] = proxy(UpdateFarm, request)
            def getSession(request: GetSessionRequest): IO[
              AwsError,
              zio.aws.deadline.model.GetSessionResponse.ReadOnly
            ] = proxy(GetSession, request)
            def disassociateMemberFromJob(
                request: DisassociateMemberFromJobRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.DisassociateMemberFromJobResponse.ReadOnly
            ] = proxy(DisassociateMemberFromJob, request)
            def listStepDependencies(
                request: ListStepDependenciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.StepDependency.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStepDependencies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStepDependenciesPaginated(
                request: ListStepDependenciesRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListStepDependenciesResponse.ReadOnly
            ] = proxy(ListStepDependenciesPaginated, request)
            def updateSession(request: UpdateSessionRequest): IO[
              AwsError,
              zio.aws.deadline.model.UpdateSessionResponse.ReadOnly
            ] = proxy(UpdateSession, request)
            def getMonitor(request: GetMonitorRequest): IO[
              AwsError,
              zio.aws.deadline.model.GetMonitorResponse.ReadOnly
            ] = proxy(GetMonitor, request)
            def getQueue(
                request: GetQueueRequest
            ): IO[AwsError, zio.aws.deadline.model.GetQueueResponse.ReadOnly] =
              proxy(GetQueue, request)
            def assumeFleetRoleForRead(
                request: AssumeFleetRoleForReadRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly
            ] = proxy(AssumeFleetRoleForRead, request)
            def listBudgets(request: ListBudgetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.BudgetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBudgets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBudgetsPaginated(request: ListBudgetsRequest): IO[
              AwsError,
              zio.aws.deadline.model.ListBudgetsResponse.ReadOnly
            ] = proxy(ListBudgetsPaginated, request)
            def getQueueFleetAssociation(
                request: GetQueueFleetAssociationRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.GetQueueFleetAssociationResponse.ReadOnly
            ] = proxy(GetQueueFleetAssociation, request)
            def deleteQueue(request: DeleteQueueRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteQueueResponse.ReadOnly
            ] = proxy(DeleteQueue, request)
            def listQueueFleetAssociations(
                request: ListQueueFleetAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.QueueFleetAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueueFleetAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueueFleetAssociationsPaginated(
                request: ListQueueFleetAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListQueueFleetAssociationsResponse.ReadOnly
            ] = proxy(ListQueueFleetAssociationsPaginated, request)
            def assumeQueueRoleForUser(
                request: AssumeQueueRoleForUserRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssumeQueueRoleForUserResponse.ReadOnly
            ] = proxy(AssumeQueueRoleForUser, request)
            def batchGetJobEntity(request: BatchGetJobEntityRequest): IO[
              AwsError,
              zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly
            ] = proxy(BatchGetJobEntity, request)
            def associateMemberToFarm(
                request: AssociateMemberToFarmRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.AssociateMemberToFarmResponse.ReadOnly
            ] = proxy(AssociateMemberToFarm, request)
            def deleteFarm(request: DeleteFarmRequest): IO[
              AwsError,
              zio.aws.deadline.model.DeleteFarmResponse.ReadOnly
            ] = proxy(DeleteFarm, request)
            def createQueueEnvironment(
                request: CreateQueueEnvironmentRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.CreateQueueEnvironmentResponse.ReadOnly
            ] = proxy(CreateQueueEnvironment, request)
            def listAvailableMeteredProducts(
                request: ListAvailableMeteredProductsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.deadline.model.MeteredProductSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAvailableMeteredProducts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAvailableMeteredProductsPaginated(
                request: ListAvailableMeteredProductsRequest
            ): IO[
              AwsError,
              zio.aws.deadline.model.ListAvailableMeteredProductsResponse.ReadOnly
            ] = proxy(ListAvailableMeteredProductsPaginated, request)
          }
        }
      }
    }
  }
}
