package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.MinZeroMaxInteger
import scala.jdk.CollectionConverters._
final case class AcceleratorCountRange(
    min: MinZeroMaxInteger,
    max: Optional[MinZeroMaxInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AcceleratorCountRange = {
    import AcceleratorCountRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AcceleratorCountRange
      .builder()
      .min(MinZeroMaxInteger.unwrap(min): Integer)
      .optionallyWith(
        max.map(value => MinZeroMaxInteger.unwrap(value): Integer)
      )(_.max)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.AcceleratorCountRange.ReadOnly =
    zio.aws.deadline.model.AcceleratorCountRange.wrap(buildAwsValue())
}
object AcceleratorCountRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AcceleratorCountRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AcceleratorCountRange =
      zio.aws.deadline.model.AcceleratorCountRange(min, max.map(value => value))
    def min: MinZeroMaxInteger
    def max: Optional[MinZeroMaxInteger]
    def getMin: ZIO[Any, Nothing, MinZeroMaxInteger] = ZIO.succeed(min)
    def getMax: ZIO[Any, AwsError, MinZeroMaxInteger] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AcceleratorCountRange
  ) extends zio.aws.deadline.model.AcceleratorCountRange.ReadOnly {
    override val min: MinZeroMaxInteger =
      zio.aws.deadline.model.primitives.MinZeroMaxInteger(impl.min())
    override val max: Optional[MinZeroMaxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => zio.aws.deadline.model.primitives.MinZeroMaxInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AcceleratorCountRange
  ): zio.aws.deadline.model.AcceleratorCountRange.ReadOnly = new Wrapper(impl)
}
