package zio.aws.deadline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.deadline.model.primitives.MinZeroMaxInteger
import scala.jdk.CollectionConverters._
final case class AcceleratorTotalMemoryMiBRange(
    min: MinZeroMaxInteger,
    max: Optional[MinZeroMaxInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AcceleratorTotalMemoryMiBRange = {
    import AcceleratorTotalMemoryMiBRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AcceleratorTotalMemoryMiBRange
      .builder()
      .min(MinZeroMaxInteger.unwrap(min): Integer)
      .optionallyWith(
        max.map(value => MinZeroMaxInteger.unwrap(value): Integer)
      )(_.max)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.ReadOnly =
    zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.wrap(buildAwsValue())
}
object AcceleratorTotalMemoryMiBRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AcceleratorTotalMemoryMiBRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange =
      zio.aws.deadline.model
        .AcceleratorTotalMemoryMiBRange(min, max.map(value => value))
    def min: MinZeroMaxInteger
    def max: Optional[MinZeroMaxInteger]
    def getMin: ZIO[Any, Nothing, MinZeroMaxInteger] = ZIO.succeed(min)
    def getMax: ZIO[Any, AwsError, MinZeroMaxInteger] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AcceleratorTotalMemoryMiBRange
  ) extends zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.ReadOnly {
    override val min: MinZeroMaxInteger =
      zio.aws.deadline.model.primitives.MinZeroMaxInteger(impl.min())
    override val max: Optional[MinZeroMaxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => zio.aws.deadline.model.primitives.MinZeroMaxInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AcceleratorTotalMemoryMiBRange
  ): zio.aws.deadline.model.AcceleratorTotalMemoryMiBRange.ReadOnly =
    new Wrapper(impl)
}
