package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait AcceleratorType {
  def unwrap: software.amazon.awssdk.services.deadline.model.AcceleratorType
}
object AcceleratorType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.AcceleratorType
  ): zio.aws.deadline.model.AcceleratorType = value match {
    case software.amazon.awssdk.services.deadline.model.AcceleratorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.AcceleratorType.GPU =>
      val r = gpu
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.AcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AcceleratorType =
      software.amazon.awssdk.services.deadline.model.AcceleratorType.UNKNOWN_TO_SDK_VERSION
  }
  case object gpu extends zio.aws.deadline.model.AcceleratorType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AcceleratorType =
      software.amazon.awssdk.services.deadline.model.AcceleratorType.GPU
  }
}
