package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssignedEnvironmentEnterSessionActionDefinition(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedEnvironmentEnterSessionActionDefinition = {
    import AssignedEnvironmentEnterSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
      .wrap(buildAwsValue())
}
object AssignedEnvironmentEnterSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition =
      zio.aws.deadline.model
        .AssignedEnvironmentEnterSessionActionDefinition(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
  ) extends zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
  ): zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
