package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.EnvironmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssignedEnvironmentExitSessionActionDefinition(
    environmentId: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedEnvironmentExitSessionActionDefinition = {
    import AssignedEnvironmentExitSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedEnvironmentExitSessionActionDefinition
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition
      .wrap(buildAwsValue())
}
object AssignedEnvironmentExitSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedEnvironmentExitSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition =
      zio.aws.deadline.model
        .AssignedEnvironmentExitSessionActionDefinition(environmentId)
    def environmentId: EnvironmentId
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedEnvironmentExitSessionActionDefinition
  ) extends zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.deadline.model.primitives.EnvironmentId(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedEnvironmentExitSessionActionDefinition
  ): zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
