package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{JobId, QueueId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssignedSession(
    queueId: QueueId,
    jobId: JobId,
    sessionActions: Iterable[zio.aws.deadline.model.AssignedSessionAction],
    logConfiguration: zio.aws.deadline.model.LogConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedSession = {
    import AssignedSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedSession
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .sessionActions(sessionActions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .logConfiguration(logConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.AssignedSession.ReadOnly =
    zio.aws.deadline.model.AssignedSession.wrap(buildAwsValue())
}
object AssignedSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssignedSession =
      zio.aws.deadline.model.AssignedSession(
        queueId,
        jobId,
        sessionActions.map { item =>
          item.asEditable
        },
        logConfiguration.asEditable
      )
    def queueId: QueueId
    def jobId: JobId
    def sessionActions
        : List[zio.aws.deadline.model.AssignedSessionAction.ReadOnly]
    def logConfiguration: zio.aws.deadline.model.LogConfiguration.ReadOnly
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getSessionActions: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.AssignedSessionAction.ReadOnly
    ]] = ZIO.succeed(sessionActions)
    def getLogConfiguration
        : ZIO[Any, Nothing, zio.aws.deadline.model.LogConfiguration.ReadOnly] =
      ZIO.succeed(logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSession
  ) extends zio.aws.deadline.model.AssignedSession.ReadOnly {
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
    override val jobId: JobId =
      zio.aws.deadline.model.primitives.JobId(impl.jobId())
    override val sessionActions
        : List[zio.aws.deadline.model.AssignedSessionAction.ReadOnly] = impl
      .sessionActions()
      .asScala
      .map { item =>
        zio.aws.deadline.model.AssignedSessionAction.wrap(item)
      }
      .toList
    override val logConfiguration
        : zio.aws.deadline.model.LogConfiguration.ReadOnly =
      zio.aws.deadline.model.LogConfiguration.wrap(impl.logConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSession
  ): zio.aws.deadline.model.AssignedSession.ReadOnly = new Wrapper(impl)
}
