package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.SessionActionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssignedSessionAction(
    sessionActionId: SessionActionId,
    definition: zio.aws.deadline.model.AssignedSessionActionDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedSessionAction = {
    import AssignedSessionAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedSessionAction
      .builder()
      .sessionActionId(
        SessionActionId.unwrap(sessionActionId): java.lang.String
      )
      .definition(definition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.AssignedSessionAction.ReadOnly =
    zio.aws.deadline.model.AssignedSessionAction.wrap(buildAwsValue())
}
object AssignedSessionAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedSessionAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssignedSessionAction =
      zio.aws.deadline.model
        .AssignedSessionAction(sessionActionId, definition.asEditable)
    def sessionActionId: SessionActionId
    def definition
        : zio.aws.deadline.model.AssignedSessionActionDefinition.ReadOnly
    def getSessionActionId: ZIO[Any, Nothing, SessionActionId] =
      ZIO.succeed(sessionActionId)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.deadline.model.AssignedSessionActionDefinition.ReadOnly
    ] = ZIO.succeed(definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSessionAction
  ) extends zio.aws.deadline.model.AssignedSessionAction.ReadOnly {
    override val sessionActionId: SessionActionId =
      zio.aws.deadline.model.primitives.SessionActionId(impl.sessionActionId())
    override val definition
        : zio.aws.deadline.model.AssignedSessionActionDefinition.ReadOnly =
      zio.aws.deadline.model.AssignedSessionActionDefinition
        .wrap(impl.definition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSessionAction
  ): zio.aws.deadline.model.AssignedSessionAction.ReadOnly = new Wrapper(impl)
}
