package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssignedSessionActionDefinition(
    envEnter: Optional[
      zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
    ] = Optional.Absent,
    envExit: Optional[
      zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition
    ] = Optional.Absent,
    taskRun: Optional[
      zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition
    ] = Optional.Absent,
    syncInputJobAttachments: Optional[
      zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedSessionActionDefinition = {
    import AssignedSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedSessionActionDefinition
      .builder()
      .optionallyWith(envEnter.map(value => value.buildAwsValue()))(_.envEnter)
      .optionallyWith(envExit.map(value => value.buildAwsValue()))(_.envExit)
      .optionallyWith(taskRun.map(value => value.buildAwsValue()))(_.taskRun)
      .optionallyWith(
        syncInputJobAttachments.map(value => value.buildAwsValue())
      )(_.syncInputJobAttachments)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssignedSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.AssignedSessionActionDefinition.wrap(buildAwsValue())
}
object AssignedSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssignedSessionActionDefinition =
      zio.aws.deadline.model.AssignedSessionActionDefinition(
        envEnter.map(value => value.asEditable),
        envExit.map(value => value.asEditable),
        taskRun.map(value => value.asEditable),
        syncInputJobAttachments.map(value => value.asEditable)
      )
    def envEnter: Optional[
      zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition.ReadOnly
    ]
    def envExit: Optional[
      zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition.ReadOnly
    ]
    def taskRun: Optional[
      zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition.ReadOnly
    ]
    def syncInputJobAttachments: Optional[
      zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition.ReadOnly
    ]
    def getEnvEnter: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("envEnter", envEnter)
    def getEnvExit: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("envExit", envExit)
    def getTaskRun: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("taskRun", taskRun)
    def getSyncInputJobAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "syncInputJobAttachments",
      syncInputJobAttachments
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSessionActionDefinition
  ) extends zio.aws.deadline.model.AssignedSessionActionDefinition.ReadOnly {
    override val envEnter: Optional[
      zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.envEnter())
      .map(value =>
        zio.aws.deadline.model.AssignedEnvironmentEnterSessionActionDefinition
          .wrap(value)
      )
    override val envExit: Optional[
      zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.envExit())
      .map(value =>
        zio.aws.deadline.model.AssignedEnvironmentExitSessionActionDefinition
          .wrap(value)
      )
    override val taskRun: Optional[
      zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRun())
      .map(value =>
        zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition
          .wrap(value)
      )
    override val syncInputJobAttachments: Optional[
      zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.syncInputJobAttachments())
      .map(value =>
        zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSessionActionDefinition
  ): zio.aws.deadline.model.AssignedSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
