package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssignedSyncInputJobAttachmentsSessionActionDefinition(
    stepId: Optional[StepId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition = {
    import AssignedSyncInputJobAttachmentsSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
      .builder()
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
      .wrap(buildAwsValue())
}
object AssignedSyncInputJobAttachmentsSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition =
      zio.aws.deadline.model
        .AssignedSyncInputJobAttachmentsSessionActionDefinition(
          stepId.map(value => value)
        )
    def stepId: Optional[StepId]
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
  ) extends zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition.ReadOnly {
    override val stepId: Optional[StepId] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => zio.aws.deadline.model.primitives.StepId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition
  ): zio.aws.deadline.model.AssignedSyncInputJobAttachmentsSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
