package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{StepId, TaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssignedTaskRunSessionActionDefinition(
    taskId: TaskId,
    stepId: StepId,
    parameters: Map[String, zio.aws.deadline.model.TaskParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssignedTaskRunSessionActionDefinition = {
    import AssignedTaskRunSessionActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssignedTaskRunSessionActionDefinition
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .parameters(
        parameters
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition.ReadOnly =
    zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition
      .wrap(buildAwsValue())
}
object AssignedTaskRunSessionActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssignedTaskRunSessionActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition =
      zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition(
        taskId,
        stepId,
        parameters.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def taskId: TaskId
    def stepId: StepId
    def parameters
        : Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
    def getParameters: ZIO[Any, Nothing, Map[
      String,
      zio.aws.deadline.model.TaskParameterValue.ReadOnly
    ]] = ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssignedTaskRunSessionActionDefinition
  ) extends zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition.ReadOnly {
    override val taskId: TaskId =
      zio.aws.deadline.model.primitives.TaskId(impl.taskId())
    override val stepId: StepId =
      zio.aws.deadline.model.primitives.StepId(impl.stepId())
    override val parameters
        : Map[String, zio.aws.deadline.model.TaskParameterValue.ReadOnly] = impl
      .parameters()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.deadline.model.TaskParameterValue.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssignedTaskRunSessionActionDefinition
  ): zio.aws.deadline.model.AssignedTaskRunSessionActionDefinition.ReadOnly =
    new Wrapper(impl)
}
