package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssumeFleetRoleForReadResponse(
    credentials: zio.aws.deadline.model.AwsCredentials
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse = {
    import AssumeFleetRoleForReadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse
      .builder()
      .credentials(credentials.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly =
    zio.aws.deadline.model.AssumeFleetRoleForReadResponse.wrap(buildAwsValue())
}
object AssumeFleetRoleForReadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssumeFleetRoleForReadResponse =
      zio.aws.deadline.model
        .AssumeFleetRoleForReadResponse(credentials.asEditable)
    def credentials: zio.aws.deadline.model.AwsCredentials.ReadOnly
    def getCredentials
        : ZIO[Any, Nothing, zio.aws.deadline.model.AwsCredentials.ReadOnly] =
      ZIO.succeed(credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse
  ) extends zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly {
    override val credentials: zio.aws.deadline.model.AwsCredentials.ReadOnly =
      zio.aws.deadline.model.AwsCredentials.wrap(impl.credentials())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssumeFleetRoleForReadResponse
  ): zio.aws.deadline.model.AssumeFleetRoleForReadResponse.ReadOnly =
    new Wrapper(impl)
}
