package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{QueueId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssumeQueueRoleForReadRequest(
    farmId: FarmId,
    queueId: QueueId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest = {
    import AssumeQueueRoleForReadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssumeQueueRoleForReadRequest.ReadOnly =
    zio.aws.deadline.model.AssumeQueueRoleForReadRequest.wrap(buildAwsValue())
}
object AssumeQueueRoleForReadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssumeQueueRoleForReadRequest =
      zio.aws.deadline.model.AssumeQueueRoleForReadRequest(farmId, queueId)
    def farmId: FarmId
    def queueId: QueueId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest
  ) extends zio.aws.deadline.model.AssumeQueueRoleForReadRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadRequest
  ): zio.aws.deadline.model.AssumeQueueRoleForReadRequest.ReadOnly =
    new Wrapper(impl)
}
