package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssumeQueueRoleForReadResponse(
    credentials: zio.aws.deadline.model.AwsCredentials
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse = {
    import AssumeQueueRoleForReadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse
      .builder()
      .credentials(credentials.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly =
    zio.aws.deadline.model.AssumeQueueRoleForReadResponse.wrap(buildAwsValue())
}
object AssumeQueueRoleForReadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssumeQueueRoleForReadResponse =
      zio.aws.deadline.model
        .AssumeQueueRoleForReadResponse(credentials.asEditable)
    def credentials: zio.aws.deadline.model.AwsCredentials.ReadOnly
    def getCredentials
        : ZIO[Any, Nothing, zio.aws.deadline.model.AwsCredentials.ReadOnly] =
      ZIO.succeed(credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse
  ) extends zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly {
    override val credentials: zio.aws.deadline.model.AwsCredentials.ReadOnly =
      zio.aws.deadline.model.AwsCredentials.wrap(impl.credentials())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForReadResponse
  ): zio.aws.deadline.model.AssumeQueueRoleForReadResponse.ReadOnly =
    new Wrapper(impl)
}
