package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{QueueId, WorkerId, FleetId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssumeQueueRoleForWorkerRequest(
    farmId: FarmId,
    fleetId: FleetId,
    workerId: WorkerId,
    queueId: QueueId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest = {
    import AssumeQueueRoleForWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest.ReadOnly =
    zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest.wrap(buildAwsValue())
}
object AssumeQueueRoleForWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest =
      zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest(
        farmId,
        fleetId,
        workerId,
        queueId
      )
    def farmId: FarmId
    def fleetId: FleetId
    def workerId: WorkerId
    def queueId: QueueId
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest
  ) extends zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
    override val queueId: QueueId =
      zio.aws.deadline.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerRequest
  ): zio.aws.deadline.model.AssumeQueueRoleForWorkerRequest.ReadOnly =
    new Wrapper(impl)
}
