package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssumeQueueRoleForWorkerResponse(
    credentials: Optional[zio.aws.deadline.model.AwsCredentials] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse = {
    import AssumeQueueRoleForWorkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly
      : zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly =
    zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse
      .wrap(buildAwsValue())
}
object AssumeQueueRoleForWorkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse =
      zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse(
        credentials.map(value => value.asEditable)
      )
    def credentials: Optional[zio.aws.deadline.model.AwsCredentials.ReadOnly]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.deadline.model.AwsCredentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse
  ) extends zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly {
    override val credentials
        : Optional[zio.aws.deadline.model.AwsCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.deadline.model.AwsCredentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AssumeQueueRoleForWorkerResponse
  ): zio.aws.deadline.model.AssumeQueueRoleForWorkerResponse.ReadOnly =
    new Wrapper(impl)
}
