package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Attachments(
    manifests: Iterable[zio.aws.deadline.model.ManifestProperties],
    fileSystem: Optional[zio.aws.deadline.model.JobAttachmentsFileSystem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.Attachments = {
    import Attachments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.Attachments
      .builder()
      .manifests(manifests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(fileSystem.map(value => value.unwrap))(_.fileSystem)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.Attachments.ReadOnly =
    zio.aws.deadline.model.Attachments.wrap(buildAwsValue())
}
object Attachments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.Attachments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.Attachments =
      zio.aws.deadline.model.Attachments(
        manifests.map { item =>
          item.asEditable
        },
        fileSystem.map(value => value)
      )
    def manifests: List[zio.aws.deadline.model.ManifestProperties.ReadOnly]
    def fileSystem: Optional[zio.aws.deadline.model.JobAttachmentsFileSystem]
    def getManifests: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.ManifestProperties.ReadOnly
    ]] = ZIO.succeed(manifests)
    def getFileSystem
        : ZIO[Any, AwsError, zio.aws.deadline.model.JobAttachmentsFileSystem] =
      AwsError.unwrapOptionField("fileSystem", fileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.Attachments
  ) extends zio.aws.deadline.model.Attachments.ReadOnly {
    override val manifests
        : List[zio.aws.deadline.model.ManifestProperties.ReadOnly] = impl
      .manifests()
      .asScala
      .map { item =>
        zio.aws.deadline.model.ManifestProperties.wrap(item)
      }
      .toList
    override val fileSystem
        : Optional[zio.aws.deadline.model.JobAttachmentsFileSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystem())
        .map(value =>
          zio.aws.deadline.model.JobAttachmentsFileSystem.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.Attachments
  ): zio.aws.deadline.model.Attachments.ReadOnly = new Wrapper(impl)
}
