package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait AutoScalingMode {
  def unwrap: software.amazon.awssdk.services.deadline.model.AutoScalingMode
}
object AutoScalingMode {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.AutoScalingMode
  ): zio.aws.deadline.model.AutoScalingMode = value match {
    case software.amazon.awssdk.services.deadline.model.AutoScalingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.AutoScalingMode.NO_SCALING =>
      val r = NO_SCALING
      r
    case software.amazon.awssdk.services.deadline.model.AutoScalingMode.EVENT_BASED_AUTO_SCALING =>
      val r = EVENT_BASED_AUTO_SCALING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.AutoScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingMode =
      software.amazon.awssdk.services.deadline.model.AutoScalingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_SCALING extends zio.aws.deadline.model.AutoScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingMode =
      software.amazon.awssdk.services.deadline.model.AutoScalingMode.NO_SCALING
  }
  case object EVENT_BASED_AUTO_SCALING
      extends zio.aws.deadline.model.AutoScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingMode =
      software.amazon.awssdk.services.deadline.model.AutoScalingMode.EVENT_BASED_AUTO_SCALING
  }
}
