package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait AutoScalingStatus {
  def unwrap: software.amazon.awssdk.services.deadline.model.AutoScalingStatus
}
object AutoScalingStatus {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.AutoScalingStatus
  ): zio.aws.deadline.model.AutoScalingStatus = value match {
    case software.amazon.awssdk.services.deadline.model.AutoScalingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.AutoScalingStatus.GROWING =>
      val r = GROWING
      r
    case software.amazon.awssdk.services.deadline.model.AutoScalingStatus.STEADY =>
      val r = STEADY
      r
    case software.amazon.awssdk.services.deadline.model.AutoScalingStatus.SHRINKING =>
      val r = SHRINKING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.AutoScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingStatus =
      software.amazon.awssdk.services.deadline.model.AutoScalingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object GROWING extends zio.aws.deadline.model.AutoScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingStatus =
      software.amazon.awssdk.services.deadline.model.AutoScalingStatus.GROWING
  }
  case object STEADY extends zio.aws.deadline.model.AutoScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingStatus =
      software.amazon.awssdk.services.deadline.model.AutoScalingStatus.STEADY
  }
  case object SHRINKING extends zio.aws.deadline.model.AutoScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.AutoScalingStatus =
      software.amazon.awssdk.services.deadline.model.AutoScalingStatus.SHRINKING
  }
}
