package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{
  SyntheticTimestamp_date_time,
  SessionToken,
  SecretAccessKey,
  AccessKeyId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AwsCredentials(
    accessKeyId: AccessKeyId,
    secretAccessKey: SecretAccessKey,
    sessionToken: SessionToken,
    expiration: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.AwsCredentials = {
    import AwsCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.AwsCredentials
      .builder()
      .accessKeyId(AccessKeyId.unwrap(accessKeyId): java.lang.String)
      .secretAccessKey(
        SecretAccessKey.unwrap(secretAccessKey): java.lang.String
      )
      .sessionToken(SessionToken.unwrap(sessionToken): java.lang.String)
      .expiration(SyntheticTimestamp_date_time.unwrap(expiration): Instant)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.AwsCredentials.ReadOnly =
    zio.aws.deadline.model.AwsCredentials.wrap(buildAwsValue())
}
object AwsCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.AwsCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.AwsCredentials =
      zio.aws.deadline.model.AwsCredentials(
        accessKeyId,
        secretAccessKey,
        sessionToken,
        expiration
      )
    def accessKeyId: AccessKeyId
    def secretAccessKey: SecretAccessKey
    def sessionToken: SessionToken
    def expiration: SyntheticTimestamp_date_time
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyId] =
      ZIO.succeed(accessKeyId)
    def getSecretAccessKey: ZIO[Any, Nothing, SecretAccessKey] =
      ZIO.succeed(secretAccessKey)
    def getSessionToken: ZIO[Any, Nothing, SessionToken] =
      ZIO.succeed(sessionToken)
    def getExpiration: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.AwsCredentials
  ) extends zio.aws.deadline.model.AwsCredentials.ReadOnly {
    override val accessKeyId: AccessKeyId =
      zio.aws.deadline.model.primitives.AccessKeyId(impl.accessKeyId())
    override val secretAccessKey: SecretAccessKey =
      zio.aws.deadline.model.primitives.SecretAccessKey(impl.secretAccessKey())
    override val sessionToken: SessionToken =
      zio.aws.deadline.model.primitives.SessionToken(impl.sessionToken())
    override val expiration: SyntheticTimestamp_date_time =
      zio.aws.deadline.model.primitives
        .SyntheticTimestamp_date_time(impl.expiration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.AwsCredentials
  ): zio.aws.deadline.model.AwsCredentials.ReadOnly = new Wrapper(impl)
}
