package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{WorkerId, FleetId, FarmId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetJobEntityRequest(
    farmId: FarmId,
    fleetId: FleetId,
    workerId: WorkerId,
    identifiers: Iterable[zio.aws.deadline.model.JobEntityIdentifiersUnion]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest = {
    import BatchGetJobEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest
      .builder()
      .farmId(FarmId.unwrap(farmId): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .workerId(WorkerId.unwrap(workerId): java.lang.String)
      .identifiers(identifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.BatchGetJobEntityRequest.ReadOnly =
    zio.aws.deadline.model.BatchGetJobEntityRequest.wrap(buildAwsValue())
}
object BatchGetJobEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.BatchGetJobEntityRequest =
      zio.aws.deadline.model.BatchGetJobEntityRequest(
        farmId,
        fleetId,
        workerId,
        identifiers.map { item =>
          item.asEditable
        }
      )
    def farmId: FarmId
    def fleetId: FleetId
    def workerId: WorkerId
    def identifiers
        : List[zio.aws.deadline.model.JobEntityIdentifiersUnion.ReadOnly]
    def getFarmId: ZIO[Any, Nothing, FarmId] = ZIO.succeed(farmId)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getWorkerId: ZIO[Any, Nothing, WorkerId] = ZIO.succeed(workerId)
    def getIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.JobEntityIdentifiersUnion.ReadOnly
    ]] = ZIO.succeed(identifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest
  ) extends zio.aws.deadline.model.BatchGetJobEntityRequest.ReadOnly {
    override val farmId: FarmId =
      zio.aws.deadline.model.primitives.FarmId(impl.farmId())
    override val fleetId: FleetId =
      zio.aws.deadline.model.primitives.FleetId(impl.fleetId())
    override val workerId: WorkerId =
      zio.aws.deadline.model.primitives.WorkerId(impl.workerId())
    override val identifiers
        : List[zio.aws.deadline.model.JobEntityIdentifiersUnion.ReadOnly] = impl
      .identifiers()
      .asScala
      .map { item =>
        zio.aws.deadline.model.JobEntityIdentifiersUnion.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.BatchGetJobEntityRequest
  ): zio.aws.deadline.model.BatchGetJobEntityRequest.ReadOnly = new Wrapper(
    impl
  )
}
