package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetJobEntityResponse(
    entities: Iterable[zio.aws.deadline.model.JobEntity],
    errors: Iterable[zio.aws.deadline.model.GetJobEntityError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse = {
    import BatchGetJobEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly =
    zio.aws.deadline.model.BatchGetJobEntityResponse.wrap(buildAwsValue())
}
object BatchGetJobEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.BatchGetJobEntityResponse =
      zio.aws.deadline.model.BatchGetJobEntityResponse(
        entities.map { item =>
          item.asEditable
        },
        errors.map { item =>
          item.asEditable
        }
      )
    def entities: List[zio.aws.deadline.model.JobEntity.ReadOnly]
    def errors: List[zio.aws.deadline.model.GetJobEntityError.ReadOnly]
    def getEntities
        : ZIO[Any, Nothing, List[zio.aws.deadline.model.JobEntity.ReadOnly]] =
      ZIO.succeed(entities)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.deadline.model.GetJobEntityError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse
  ) extends zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly {
    override val entities: List[zio.aws.deadline.model.JobEntity.ReadOnly] =
      impl
        .entities()
        .asScala
        .map { item =>
          zio.aws.deadline.model.JobEntity.wrap(item)
        }
        .toList
    override val errors
        : List[zio.aws.deadline.model.GetJobEntityError.ReadOnly] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.deadline.model.GetJobEntityError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.BatchGetJobEntityResponse
  ): zio.aws.deadline.model.BatchGetJobEntityResponse.ReadOnly = new Wrapper(
    impl
  )
}
