package zio.aws.deadline.model
import zio.aws.deadline.model.primitives.{Description, ThresholdPercentage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BudgetActionToAdd(
    `type`: zio.aws.deadline.model.BudgetActionType,
    thresholdPercentage: ThresholdPercentage,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.BudgetActionToAdd = {
    import BudgetActionToAdd.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.BudgetActionToAdd
      .builder()
      .`type`(`type`.unwrap)
      .thresholdPercentage(
        ThresholdPercentage.unwrap(thresholdPercentage): java.lang.Float
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.BudgetActionToAdd.ReadOnly =
    zio.aws.deadline.model.BudgetActionToAdd.wrap(buildAwsValue())
}
object BudgetActionToAdd {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.BudgetActionToAdd
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.BudgetActionToAdd =
      zio.aws.deadline.model.BudgetActionToAdd(
        `type`,
        thresholdPercentage,
        description.map(value => value)
      )
    def `type`: zio.aws.deadline.model.BudgetActionType
    def thresholdPercentage: ThresholdPercentage
    def description: Optional[Description]
    def getType: ZIO[Any, Nothing, zio.aws.deadline.model.BudgetActionType] =
      ZIO.succeed(`type`)
    def getThresholdPercentage: ZIO[Any, Nothing, ThresholdPercentage] =
      ZIO.succeed(thresholdPercentage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.BudgetActionToAdd
  ) extends zio.aws.deadline.model.BudgetActionToAdd.ReadOnly {
    override val `type`: zio.aws.deadline.model.BudgetActionType =
      zio.aws.deadline.model.BudgetActionType.wrap(impl.`type`())
    override val thresholdPercentage: ThresholdPercentage =
      zio.aws.deadline.model.primitives
        .ThresholdPercentage(impl.thresholdPercentage())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.deadline.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.BudgetActionToAdd
  ): zio.aws.deadline.model.BudgetActionToAdd.ReadOnly = new Wrapper(impl)
}
