package zio.aws.deadline.model
import scala.jdk.CollectionConverters._
sealed trait BudgetActionType {
  def unwrap: software.amazon.awssdk.services.deadline.model.BudgetActionType
}
object BudgetActionType {
  def wrap(
      value: software.amazon.awssdk.services.deadline.model.BudgetActionType
  ): zio.aws.deadline.model.BudgetActionType = value match {
    case software.amazon.awssdk.services.deadline.model.BudgetActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.deadline.model.BudgetActionType.STOP_SCHEDULING_AND_COMPLETE_TASKS =>
      val r = STOP_SCHEDULING_AND_COMPLETE_TASKS
      r
    case software.amazon.awssdk.services.deadline.model.BudgetActionType.STOP_SCHEDULING_AND_CANCEL_TASKS =>
      val r = STOP_SCHEDULING_AND_CANCEL_TASKS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.deadline.model.BudgetActionType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.BudgetActionType =
      software.amazon.awssdk.services.deadline.model.BudgetActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object STOP_SCHEDULING_AND_COMPLETE_TASKS
      extends zio.aws.deadline.model.BudgetActionType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.BudgetActionType =
      software.amazon.awssdk.services.deadline.model.BudgetActionType.STOP_SCHEDULING_AND_COMPLETE_TASKS
  }
  case object STOP_SCHEDULING_AND_CANCEL_TASKS
      extends zio.aws.deadline.model.BudgetActionType {
    override def unwrap
        : software.amazon.awssdk.services.deadline.model.BudgetActionType =
      software.amazon.awssdk.services.deadline.model.BudgetActionType.STOP_SCHEDULING_AND_CANCEL_TASKS
  }
}
