package zio.aws.deadline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BudgetSchedule(
    fixed: Optional[zio.aws.deadline.model.FixedBudgetSchedule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.deadline.model.BudgetSchedule = {
    import BudgetSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.deadline.model.BudgetSchedule
      .builder()
      .optionallyWith(fixed.map(value => value.buildAwsValue()))(_.fixed)
      .build()
  }
  def asReadOnly: zio.aws.deadline.model.BudgetSchedule.ReadOnly =
    zio.aws.deadline.model.BudgetSchedule.wrap(buildAwsValue())
}
object BudgetSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.deadline.model.BudgetSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.deadline.model.BudgetSchedule =
      zio.aws.deadline.model
        .BudgetSchedule(fixed.map(value => value.asEditable))
    def fixed: Optional[zio.aws.deadline.model.FixedBudgetSchedule.ReadOnly]
    def getFixed: ZIO[
      Any,
      AwsError,
      zio.aws.deadline.model.FixedBudgetSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("fixed", fixed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.deadline.model.BudgetSchedule
  ) extends zio.aws.deadline.model.BudgetSchedule.ReadOnly {
    override val fixed
        : Optional[zio.aws.deadline.model.FixedBudgetSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixed())
        .map(value => zio.aws.deadline.model.FixedBudgetSchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.deadline.model.BudgetSchedule
  ): zio.aws.deadline.model.BudgetSchedule.ReadOnly = new Wrapper(impl)
}
